<?php

/**
 * Forever Wedding - Touch Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_special_wishes');

function foreverwedding_special_wishes() {
    vc_map(array(
        "name" => esc_html__("Forever Wedding special wishes section", 'foreverwedding'),
        "base" => "foreverwedding_special_wishes",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Special Wishes Title", 'foreverwedding'),
                "param_name" => "special_wishes",
                "value" => '',
                "description" => esc_html__("Enter special wishes here", 'foreverwedding')
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section button link", 'foreverwedding'),
                "param_name" => "button_link",
                "value" => '',
                "description" => esc_html__("Enter button link", 'foreverwedding')
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section button label", 'foreverwedding'),
                "param_name" => "button_text",
                "value" => '',
                "description" => esc_html__("Enter button label", 'foreverwedding')
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_special_wishes extends WPBakeryShortCode { }
