<?php

/**
 * Forever Wedding - Services Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_services');

function foreverwedding_services() {
    vc_map(array(
        "name" => esc_html__("Foreverwedding service section", 'foreverwedding'),
        "base" => "foreverwedding_services",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
         array(
                "type" => "attach_image",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Attach Section Background Image", 'foreverwedding'),
                "param_name" => "service_background_image",
                "value" => '',
                "description" => esc_html__("Attach Section Background Image Here", 'foreverwedding')
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Title", 'foreverwedding'),
                "param_name" => "inner_title",
                "value" => '',
                "description" => esc_html__("Enter section title", 'foreverwedding')
            ),
            array(
                "type" => "textarea",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Service Content", 'foreverwedding'),
                "param_name" => "service_content",
                "value" => '',
                "description" => esc_html__("Enter Service Content Here.", 'foreverwedding')
            ),
            array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "service_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                array(
                        'type' => 'attach_image',
                        'value' => '',
                        'heading' => 'Upload service Image',
                        'param_name' => 'service_image',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Service Name',
                        'param_name' => 'service_name',
                        "description" => esc_html__("Enter service name here", 'foreverwedding')
                    ),
                    array(
                        'type' => 'dropdown',
                        'value' => ForeverWedding_select_page(),
                        'heading' => 'Select Service Page',
                        'param_name' => 'event_title_link',
                    ),
                ),
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_services extends WPBakeryShortCode { }
