<?php

/**
 * Forever Wedding - Our Team Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_our_team');

function foreverwedding_our_team() {
    vc_map(array(
        "name" => esc_html__("Forever Wedding Our Team", 'foreverwedding'),
        "base" => "foreverwedding_our_team",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Title", 'foreverwedding'),
                "param_name" => "inner_title",
                "value" => '',
                "description" => esc_html__("Enter section title", 'foreverwedding')
            ),
                array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "our_team_section_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                 array(
                        'type' => 'attach_image',
                        'value' => '',
                        'heading' => 'Upload Team Image',
                        'param_name' => 'team_image',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Team Member Name',
                        'param_name' => 'team_member_name',
                    ),
                     array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Team Member Designation',
                        'param_name' => 'team_member_designation',
                    ),
                  	array(
                        "type" => "textarea",
                        "holder" => "",
                        "class" => "",
                        "heading" => esc_html__("Team Member Views", 'foreverwedding'),
                        "param_name" => "team_member_views",
                        "value" => '',
                        "description" => esc_html__("Enter team member views here", 'foreverwedding')
                    ),                    
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Please Enter Twitter Link',
                        'param_name' => 'twitter',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Please Enter Facebook Link',
                        'param_name' => 'facebook',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Please Enter Google Plus Link',
                        'param_name' => 'google_plus',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Please Enter Linkedin Link',
                        'param_name' => 'linkedin',
                    ),
                ),
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_our_team extends WPBakeryShortCode { }
