<?php

/**
 * Forever Wedding - Accomodations Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_accomodations');

function foreverwedding_accomodations() {
    vc_map(array(
        "name" => esc_html__("Forever Wedding Accomodations", 'foreverwedding'),
        "base" => "foreverwedding_accomodations",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Title", 'foreverwedding'),
                "param_name" => "title",
                "value" => '',
                "description" => esc_html__("Enter section title", 'foreverwedding')
            ),
             array(
                "type" => "textarea",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Accomodation Content", 'foreverwedding'),
                "param_name" => "accomodation_content",
                "value" => '',
                "description" => esc_html__("Enter Accomodation Content Here.", 'foreverwedding')
            ),
            array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "accomodation_section_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                array(
                        'type' => 'attach_image',
                        'value' => '',
                        'heading' => 'Upload Accomodation Section Image',
                        'param_name' => 'accomodation_image',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Section title',
                        'param_name' => 'section_heading',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Address Information',
                        'param_name' => 'accomodation_address',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Contact Information',
                        'param_name' => 'accomodation_contact',
                    ),
                   array(
                        'type' => 'textarea',
                        'holder' => '',
                        'class' => '',
                        'heading' => esc_html__('Section Content', 'foreverwedding'),
                        'param_name' => 'accomodation_section_content',
                        'value' => '',
                        'description' => esc_html__('Enter accomodation section content', 'foreverwedding')
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter button link',
                        'param_name' => 'visit_link',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter button label',
                        'param_name' => 'visit_website',
                    ),
                ),
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_accomodations extends WPBakeryShortCode { }
