<?php
/**
 * Forever Wedding - What We Do Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'inner_title' => '',
    'what_we_do_content' => '',
    'what_do_repeater' => '',
		), $atts));
?>
<div class="home-agency">
    <section class="what-we-do">
	<div class="container">
	    <div class="row">
		<div class="info-wrap">
		    <?php if (!empty($inner_title)): ?>
    		    <h2><?php echo esc_html($inner_title); ?></h2>
		    <?php endif; ?>
		    <?php if (!empty($what_we_do_content)): ?>
    		    <p><?php echo esc_html($what_we_do_content); ?></p>
		    <?php endif; ?>
		</div>
	    </div>

	    <div class="row">
		<?php
		$what_do_repeater = vc_param_group_parse_atts($atts['what_do_repeater']);
		if (!empty($what_do_repeater) && is_array($what_do_repeater)):
		    foreach ($what_do_repeater as $do_item):
			?>	
			<div class="col-xs-12 col-sm-4">
			    <div class="event-img">
				<?php
				if (isset($do_item['event_image'])):
				    $event_image = wp_get_attachment_url($do_item['event_image']);
				    if (!empty($event_image)) {
					?> 
					<span><img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($event_image), '370', '239'); ?>" alt="<?php echo esc_attr($do_item['event_image']); ?>" title="<?php echo esc_attr($do_item['event_image']); ?>" /></span>
					<?php
				    }
				endif;
				?> 

				<?php
				if (isset($do_item['class_name'])):
				    $class_name = $do_item['class_name'];
				    if (!empty($class_name)) {
					?> 
					<a href="<?php echo esc_url(get_permalink($do_item['event_title_link'])); ?>"><i class="<?php echo esc_html($class_name); ?>"></i></a>
				    <?php } endif; ?>
			    </div>
			    <div class="event">
				<?php
				if (isset($do_item['event_title'])):
				    $event_title = $do_item['event_title'];
				    if (!empty($event_title)) {
					?> 
					<h3><a href="<?php echo esc_url(get_permalink($do_item['event_title_link'])); ?>"><?php echo esc_html($event_title); ?></a></h3>
				    <?php } endif; ?>
				<?php if (isset($do_item['event_content'])): ?>
	    			<p><?php echo wp_kses($do_item['event_content'], wp_kses_allowed_html('post')); ?></p>
				<?php endif; ?> 
			    </div>
			</div>
			<?php
		    endforeach;
		endif;
		?>
	    </div>
	</div>
    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_what_we_do'));
