<?php
/**
 * Forever Wedding - wedding event
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
		), $atts));
?>  
<section class="wedding-event">
    <div class="wedding-event-top">
	<div class="container">
	    <div class="row">
		<div class="col-xs-12">
		    <?php if (!empty($title)): ?>
    		    <div class="header-center">
    			<h2><?php echo esc_html($title); ?></h2>
    		    </div>
		    <?php endif; ?>
		</div>
	    </div>
	</div>
    </div>
    <div class="container">
	<?php
	$args = array(
	    'post_type' => 'event',
	    'post_status' => 'publish',
	    'order' => 'ASC',
	    'posts_per_page' => -1,
	);

	$event_query = new WP_Query($args);
	$count = 1;
	if ($event_query->have_posts()) :
	    while ($event_query->have_posts()) : $event_query->the_post();
		if ($count % 2 == 0) {
		    ?>
	    	<div class="row padding-right">
	    	    <div class="col-xs-12 col-md-7 col-sm-7 event-img-sec">
			    <?php
			    $esvg_id = get_post_meta(get_the_id(), 'event_select_svg', true);
			    if (has_post_thumbnail($esvg_id)) :
				$esrc = wp_get_attachment_url(get_post_thumbnail_id($esvg_id), 'full');
				?> 
				<figure>  <img src="<?php echo esc_url($esrc); ?>" alt="<?php echo esc_attr(get_the_title($esvg_id)); ?>" title="<?php echo esc_attr(get_the_title($esvg_id)); ?>"/></figure>
				<?php
			    endif;
			    ?>
	    	    </div>
	    	    <div class="col-xs-12 col-md-5 col-sm-5 push">
	    		<div class="event-description-wrapper reception-description-sec">
	    		    <div class="event-description">
	    			<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
	    			<span class="day-class"><?php echo (get_post_meta(get_the_ID(), 'ceremony_date', true)); ?></span>
	    			<address>
	    			    <span class="map-class"><?php echo (get_post_meta(get_the_ID(), 'ceremony_address', true)); ?></span>
	    			</address>
				    <?php the_content(); ?>
	    			<a class="read-more" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'foreverwedding'); ?> <i class="fa fa-angle-right"></i></a>
	    		    </div>
	    		</div>
	    	    </div>
	    	</div>
		    <?php
		}else {
		    ?>
	    	<div class="row padding-right">
	    	    <div class="col-xs-12 col-md-7 col-sm-7">
			    <?php
			    $esvg_id = get_post_meta(get_the_id(), 'event_select_svg', true);
			    if (has_post_thumbnail($esvg_id)) :
				$esrc = wp_get_attachment_url(get_post_thumbnail_id($esvg_id), 'full');
				?> 
				<figure>  <img src="<?php echo esc_url($esrc); ?>" alt="<?php echo esc_attr(get_the_title($esvg_id)); ?>" title="<?php echo esc_attr(get_the_title($esvg_id)); ?>"/></figure>
				<?php
			    endif;
			    ?>
	    	    </div>
	    	    <div class="col-xs-12 col-md-pull-1 col-md-5 col-sm-pull-2 col-sm-5 event-img-sec-top">
	    		<div class="event-description-wrapper">
	    		    <div class="event-description">
	    			<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
	    			<span class="day-class"><?php echo (get_post_meta(get_the_ID(), 'ceremony_date', true)); ?></span>
	    			<address>
	    			    <span class="map-class"><?php echo (get_post_meta(get_the_ID(), 'ceremony_address', true)); ?></span>
	    			</address>
				    <?php the_content(); ?>
	    			<a class="read-more" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'foreverwedding'); ?> <i class="fa fa-angle-right"></i></a>
	    		    </div>
	    		</div>
	    	    </div>
	    	</div>
		<?php } ?>
		<?php
		$count++;
	    endwhile;
	endif;
	wp_reset_postdata();
	?>		
    </div>
</section>
<?php
echo ($this->endBlockComment('foreverwedding_wedding_event'));
