<?php
/**
 * Forever Wedding - Services Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'service_background_image' => '',
    'inner_title' => '',
    'service_content' => '',
    'service_repeater' => '',
		), $atts));
?>
<div class="home-agency">
    <?php $service_background_img = wp_get_attachment_image_src($service_background_image, 'full'); ?>
    <section class="services" style="background-image: url(<?php echo esc_attr($service_background_img[0]); ?>)">
	<div class="container">
	    <div class="row">
		<div class="info-wrap">
		    <?php if (!empty($inner_title)): ?>
    		    <h2><?php echo esc_html($inner_title); ?></h2>
		    <?php endif; ?>
		    <?php if (!empty($service_content)): ?>
    		    <p><?php echo esc_html($service_content); ?></p>
		    <?php endif; ?>
		</div>
	    </div>
	    <div class="row">
		<?php
		$service_repeater = vc_param_group_parse_atts($atts['service_repeater']);
		if (!empty($service_repeater) && is_array($service_repeater)):
		    foreach ($service_repeater as $srvc_repeater):
			?>
			<div class="col-xs-12 col-sm-3">
			    <?php
			    if (isset($srvc_repeater['service_image']) && isset($srvc_repeater['service_name'])):
				$service_image = wp_get_attachment_url($srvc_repeater['service_image']);
				$service_name = $srvc_repeater['service_name'];
				if (!empty($service_image) && !empty($service_name)) {
				    ?> 
				    <a href="<?php echo esc_url(get_permalink($srvc_repeater['event_title_link'])); ?>" class="circle"> <span class="type-name"> <img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($service_image), '118', '97'); ?>" alt="<?php echo esc_attr($srvc_repeater['service_image']); ?>" title="<?php echo esc_attr($srvc_repeater['service_image']); ?>" /> <span><?php echo esc_html($service_name); ?></span> </span> </a>
					    <?php
					}
				    endif;
				    ?> 
			</div>
			<?php
		    endforeach;
		endif;
		?>
	    </div>
	</div>
    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_services'));
