<?php
/**
 * Forever Wedding - What We Do Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'inner_title' => '',
    'post_no' => '',
    'order_no' => 'ASC',
    
		), $atts));
?>
<div class="home-agency">
    <section class="recent-posts">
	<div class="container">
	    <div class="row">
		<div class="info-wrap">
		    <?php if (!empty($inner_title)): ?>
    		    <h2><?php echo esc_html($inner_title); ?></h2>
		    <?php endif; ?>
		</div>
	    </div>
	    <div class="row">
		<?php
		if (empty($post_no)) {
		    $post_no = 3;
		}
		$args = array(
		    'post_type' => 'post',
		    'post_status' => 'publish',
		    'order' => $order_no,
		    'posts_per_page' => $post_no,
		);
		$post_query = new WP_Query($args);
		if ($post_query->have_posts()) :
		    while ($post_query->have_posts()) : $post_query->the_post();
			?>
			<div class="col-xs-12 col-sm-4">
			    <?php
			    $psvg_id = get_post_meta(get_the_id(), 'post_select_svg', true);
			    if (has_post_thumbnail($psvg_id)) :
				$psrc = wp_get_attachment_url(get_post_thumbnail_id($psvg_id), 'full');
				?> 
	    		    <figure>  <img src="<?php echo esc_url($psrc); ?>" alt="<?php echo esc_attr(get_the_title($psvg_id)); ?>" title="<?php echo esc_attr(get_the_title($psvg_id)); ?>"/></figure>
				<?php
			    endif;
			    ?>
			    <div class="post-blog">
				<span class="timing-blog"><i class="fa fa-calendar"> </i> <span> <?php echo get_the_date(); ?> </span> 
				    <?php
				    //$category = get_the_category(); 
				    //if(!empty(array_filter($category))):
				    ?>
				    <?php echo apply_filters('foreverwedding_category_filter', get_the_ID()); ?> 
				    <?php //endif;  ?></span>
				<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
				<?php the_content(); ?>
				<a class="btn btn-default" href="<?php the_permalink(); ?>"> <?php esc_html_e('READ MORE', 'foreverwedding'); ?> <i class="fa fa-angle-right"> </i> </a>
			    </div>
			</div>
			<?php
		    endwhile;
		endif;
		wp_reset_postdata();
		?>
	    </div>
	</div>
    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_recent_posts'));
