<?php
/**
 * Forever Wedding - How We Do Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'inner_title' => '',
    'how_we_do_content' => '',
    'how_do_repeater' => '',
		), $atts));
?>
<div class="home-agency">
    <section class="how-we-do">
	<div class="container">
	    <div class="row">
		<div class="info-wrap">
		    <?php if (!empty($inner_title)): ?>
    		    <h2><?php echo esc_html($inner_title); ?></h2>
		    <?php endif; ?>
		    <?php if (!empty($how_we_do_content)): ?>
    		    <p><?php echo esc_html($how_we_do_content); ?></p>
		    <?php endif; ?>
		</div>
	    </div>
	    <div class="row">
		<?php
		$how_do_repeater = vc_param_group_parse_atts($atts['how_do_repeater']);
		if (!empty($how_do_repeater) && is_array($how_do_repeater)):
		    foreach ($how_do_repeater as $how_do_item):
			?>	
			<div class="col-xs-12 col-sm-4">
			    <div class="event">
				<?php
				if (isset($how_do_item['clas_name'])):
				    $clas_name = $how_do_item['clas_name'];
				    if (!empty($clas_name)) {
					?> 
					<a href="<?php echo esc_url(get_permalink($how_do_item['event_title_link'])); ?>"><i class="<?php echo esc_html($clas_name); ?>"></i></a>
					<?php } endif; ?>
				    <?php
				    if (isset($how_do_item['evnt_title'])):
					$evnt_title = $how_do_item['evnt_title'];
					if (!empty($evnt_title)) {
					    ?> 
					<strong><?php echo esc_html($evnt_title); ?></strong>
				    <?php } endif; ?>
				<?php if (isset($how_do_item['evnt_content'])): ?>
	    			<p><?php echo wp_kses($how_do_item['evnt_content'], wp_kses_allowed_html('post')); ?></p>
				<?php endif; ?> 
			    </div>
			</div>
			<?php
		    endforeach;
		endif;
		?>
	    </div>
	</div>
    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_how_we_do'));
