<?php
/**
 * Forever Wedding - Hotals Listing
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
    'section_content' => '',
		), $atts));
?>
<div class="locate-hotels travel-page">
    <div class="map-wrap">
	<div id="map-view"></div>
    </div>
    <!-- map end here -->

    <!-- accomodation start here -->
    <section class="travel-page-content">
	<div class="container">
	    <div class="row">
		<div class="header-center-content">
		    <?php if (!empty($title)): ?>
    		    <h2><?php echo esc_html($title); ?></h2>
			<?php
		    endif;
		    if (!empty($section_content)):
			?>
    		    <p><?php echo esc_html($section_content); ?></p>
		    <?php endif; ?>
		</div>
	    </div>
	    <?php
	    $LatLng = array();
	    $hotalQuery = new WP_Query(array('post_type' => 'hotels', 'posts_per_page' => get_option('posts_per_page')));
	    if ($hotalQuery->have_posts()):
		while ($hotalQuery->have_posts()):
		    $hotalQuery->the_post();
		    $LatLng[] = array(
			get_post_meta(get_the_ID(), 'latitude', true),
			get_post_meta(get_the_ID(), 'longitude', true)
		    );
		    ?>
		    <div class="row bg-color">
			<div class="col-xs-12 col-sm-6">

			    <div class="left-part">
				<figure>
				    <img src="<?php echo apply_filters('foreverwedding_image_resize', wp_get_attachment_url(get_post_thumbnail_id()), '570', '407'); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" title="<?php echo esc_attr(get_the_title()); ?>">
				</figure>

			    </div>
			</div>
			<div class="col-xs-12 col-sm-6">
			    <div class="right-part">
				<div class="left-part-header">
				    <h3><?php the_title(); ?></h3>
				</div>
				<address>
				    <?php
				    $address = get_post_meta(get_the_ID(), 'address', true);
				    if (!empty($address)):
					?>
	    			    <i class="fa fa-map-marker add-map"> </i>
	    			    <span><?php echo esc_html($address); ?></span>
				    <?php endif; ?>

				    <?php
				    $phone = get_post_meta(get_the_ID(), 'phone', true);
				    if (!empty($phone)):
					?>
	    			    <span><?php echo esc_html($phone); ?></span>
	    			    <i class="fa fa-phone add-phone"></i>
				    <?php endif; ?>
				</address>
				<?php the_content(); ?>
				<?php
				$site_link = get_post_meta(get_the_ID(), 'site_link', true);
				if (!empty($site_link)):
				    ?>
	    			<a class="btn btn-default" href="<?php echo esc_url($site_link); ?>"><?php echo esc_html('Visit Website', 'foreverwedding'); ?></a>
				<?php endif; ?>

			    </div>
			</div>

		    </div>
		    <?php
		endwhile;
		foreverwedding_pagenavi($hotalQuery);
		wp_reset_postdata();
	    endif;

	    wp_localize_script('foreverwedding.site', 'FOREVERWEDDING_HOTELS', $LatLng);
	    ?>
	</div>
    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_hotels'));
