<?php
/**
 * Forever Wedding - Happy Couple Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
    'section_repeater' => '',
		), $atts));
?>
<section class="happy-couple">
    <div class="container">
        <div class="row">
            <div class="col-xs-12">
		<?php if (!empty($title)): ?>
    		<div class="header-center">
    		    <h2><?php echo esc_html($title); ?></h2>
    		</div><?php endif; ?>

		<?php
		$section_repeater = vc_param_group_parse_atts($atts['section_repeater']);
		$class = 1;
		if (!empty($section_repeater) && is_array($section_repeater)):
		    foreach ($section_repeater as $list_item):
			$classattr = ($class == 1) ? 'bell' : 'jack';
			?>	
			<div class="<?php echo esc_attr($classattr); ?>">
			    <?php
			    if (isset($list_item['section_image'])):
				$section_image = wp_get_attachment_url($list_item['section_image']);
				if (!empty($section_image)) {
				    ?> 
				    <img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($section_image), '585', '360'); ?>" alt="<?php echo esc_attr($list_item['section_image']); ?>" title="<?php echo esc_attr($list_item['section_image']); ?>" />
				    <?php
				}
			    endif;
			    ?> 
			    <div class="inner-header-wrapper-left inner-header-wrapper">
				<?php
				if (isset($list_item['section_title'])):
				    $section_title = $list_item['section_title'];
				    if (!empty($section_title)) {
					?> 
					<h3><a href="javascript:void(0);"><?php echo esc_html($section_title); ?></a></h3>
				    <?php } endif; ?> 
				<?php if (isset($list_item['section_content'])): ?>
	    			<p><?php echo wp_kses($list_item['section_content'], wp_kses_allowed_html('post')); ?></p>
				<?php endif; ?> 
				<?php
				if (isset($list_item['section_bottom_image'])):
				    $section_bottom_image = wp_get_attachment_url($list_item['section_bottom_image']);
				    if (!empty($section_image)) {
					?> 
					<img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($section_bottom_image), '398', '251'); ?>" alt="<?php echo esc_attr($list_item['section_bottom_image']); ?>" title="<?php echo esc_attr($list_item['section_bottom_image']); ?>" />
					<?php
				    }
				endif;
				?> 	
			    </div>
			</div>
			<?php
			$class++;
		    endforeach;
		endif;
		?>
            </div>
        </div>
    </div>
</section>
<?php
echo ($this->endBlockComment('foreverwedding_happy_couple'));
