<?php
/**
 * Forever Wedding - Wedding Gifts
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'attending_bg_img' => '',
    'inner_title' => '',
    'attending_content' => '',
    'form_title' => '',
    'form_content' => '',
    'form_field' => '',
		), $atts));
?>
<?php $attnding_bg_img = wp_get_attachment_image_src($attending_bg_img, 'full'); ?>
<div class="home-agency home-inner-agency">
    <section class="attending-class" style="background-image: url(<?php echo esc_attr($attnding_bg_img[0]); ?>)">
	<div class="container">
	    <div class="row">
		<div class="info-wrap">
		    <?php if (!empty($inner_title)): ?>
    		    <h2><?php echo esc_html($inner_title); ?></h2>
		    <?php endif; ?>
		    <?php if (!empty($attending_content)): ?>
    		    <p><?php echo esc_html($attending_content); ?></p>
		    <?php endif; ?>
		</div>
	    </div>
	    <?php if (!empty($form_field)): ?>
    	    <div class="row text-center">
    		<div class="col-xs-12 col-sm-10 col-sm-push-1">
    		    <div class="rsvp-wrapper" data-ng-controller="rsvp2Ctrl">
			    <?php if (!empty($form_title)): ?>
				<h3><?php echo esc_html($form_title); ?></h3>
			    <?php endif; ?>
			    <?php if (!empty($form_content)): ?>
				<span class="plz-cls"><?php echo esc_html($form_content); ?></span>
			    <?php endif; ?>
			    <?php echo do_shortcode('[contact-form-7 id="' . $form_field . '" title="' . get_the_title($form_field) . '"]'); ?>
    		    </div>
    		</div>
    	    </div>
		<?php
	    endif;
	    ?>
	</div>
    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_get_in_touch'));
