<?php
/**
 * Forever Wedding - Brand Ticker Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
    'bg_color' => '',
    'brand_ticker_section_repeater' => '',
		), $atts));
?>
<div class="wedding-section-gift" style="background-color:<?php echo esc_attr($bg_color); ?>">
    <div class="container">
	<?php if (!empty($title)): ?>
    	<div class="header-center">
    	    <h2><?php echo esc_html($title); ?></h2>
    	</div><?php endif; ?>
	<div class="wedding-item" dir="ltr">
	    <?php
	    $brand_ticker_section_repeater = vc_param_group_parse_atts($atts['brand_ticker_section_repeater']);
	    if (!empty($brand_ticker_section_repeater) && is_array($brand_ticker_section_repeater)):
		foreach ($brand_ticker_section_repeater as $ticker_section_repeater):
		    ?>	
		    <div class="item">
			<div class="gift-class">
			    <?php
			    if (isset($ticker_section_repeater['brand_ticker_image'])):
				$brand_ticker_image = wp_get_attachment_url($ticker_section_repeater['brand_ticker_image']);
				if (!empty($brand_ticker_image)) {
					$title= get_post($ticker_section_repeater['brand_ticker_image'])->post_title;
				    ?> 
				    <img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($brand_ticker_image), '270', '312'); ?>" alt="<?php echo esc_attr($title); ?>" title="<?php echo esc_attr($title); ?>" />
				    <?php
				}
			    endif;
			    ?> 	
			</div>
		    </div>
		    <?php
		endforeach;
	    endif;
	    ?>
	</div>
    </div>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_brand_ticker'));
