<?php
/**
 * Forever Wedding - Accomodations Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
    'accomodation_content' => '',
		), $atts));
?>
<div id="map"></div>
<div class="travel-page">
    <section class="travel-page-content">
        <div class="container">
            <div class="row">
                <div class="header-center-content">
		    <?php if (!empty($title)): ?>
    		    <h2><?php echo esc_html($title); ?></h2>
		    <?php endif; ?>
		    <?php if (!empty($accomodation_content)): ?>
    		    <p><?php echo esc_html($accomodation_content); ?></p>
		    <?php endif; ?>
                </div>
            </div>
	    <?php
	    $accomodation_section_repeater = vc_param_group_parse_atts($atts['accomodation_section_repeater']);
	    if (!empty($accomodation_section_repeater) && is_array($accomodation_section_repeater)):
		foreach ($accomodation_section_repeater as $acomodatn_section_repeater):
		    ?>	
		    <div class="row bg-color">
			<div class="col-xs-12 col-sm-6">
			    <div class="left-part">
				<?php
				if (isset($acomodatn_section_repeater['accomodation_image'])):
				    $accomodation_image = wp_get_attachment_url($acomodatn_section_repeater['accomodation_image']);
				    if (!empty($accomodation_image)) {
					?> 
					<figure>  <img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($accomodation_image), '570', '407'); ?>" alt="<?php echo esc_attr($acomodatn_section_repeater['accomodation_image']); ?>" title="<?php echo esc_attr($acomodatn_section_repeater['accomodation_image']); ?>" /></figure>
					<?php
				    }
				endif;
				?>
			    </div>
			</div>
			<div class="col-xs-12 col-sm-6">
			    <div class="right-part">
				<div class="left-part-header">
				    <?php
				    if (isset($acomodatn_section_repeater['section_heading'])):
					$section_heading = $acomodatn_section_repeater['section_heading'];
					if (!empty($section_heading)) {
					    ?> 
					    <h3><a href="#"><?php echo esc_html($section_heading); ?></a></h3>
					<?php } endif; ?> 
				</div>
				<address>
				    <?php
				    if (isset($acomodatn_section_repeater['accomodation_address'])):
					$accomodation_address = $acomodatn_section_repeater['accomodation_address'];
					if (!empty($accomodation_address)) {
					    ?> 
					    <i class="fa fa-map-marker add-map"> </i>
					    <span><?php echo esc_html($accomodation_address); ?></span>
					<?php } endif; ?> 
				    <?php
				    if (isset($acomodatn_section_repeater['accomodation_contact'])):
					$accomodation_contact = $acomodatn_section_repeater['accomodation_contact'];
					if (!empty($accomodation_contact)) {
					    ?> 
					    <span><?php echo esc_html($accomodation_contact); ?></span>
					    <i class="fa fa-phone add-phone"></i>
					<?php } endif; ?> 
				</address>
				<?php if (isset($acomodatn_section_repeater['accomodation_section_content'])): ?>
	    			<p><?php echo wp_kses($acomodatn_section_repeater['accomodation_section_content'], wp_kses_allowed_html('post')); ?></p>
				<?php endif; ?> 
				<?php
				if (isset($acomodatn_section_repeater['visit_website'])):
				    $visit_website = $acomodatn_section_repeater['visit_website'];
				    if (!empty($visit_website)) {
					?> 
					<a class="btn btn-default" href="<?php echo esc_url($acomodatn_section_repeater['visit_link']); ?>"><?php echo esc_html($visit_website); ?></a>
				    <?php } endif; ?> 									
			    </div>
			</div>
		    </div>
		    <?php
		endforeach;
	    endif;
	    ?>
        </div>
    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_accomodations'));
