<?php
/**
 * Forever Wedding - about us
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'inner_title' => '',
    'about_us_main_content' => '',
    'about_us_content' => '',
    'video_link' => '',
    'video_bg_img' => '',
		), $atts));
?>
<div class="home-agency">
    <section class="about-us">
	<div class="container">
	    <div class="row">
		<div class="info-wrap">
		    <?php if (!empty($inner_title)): ?>
    		    <h2><?php echo esc_html($inner_title); ?></h2>
		    <?php endif; ?>
		</div>
	    </div>
	</div>
	<div class="blog-wrap clearfix">
	    <div class="detail">
		<?php if (!empty($about_us_main_content)): ?>
    		<p class="para1"><?php echo esc_html($about_us_main_content); ?></p>
		<?php endif; ?>
		<?php if (!empty($about_us_content)): ?>
    		<p class="para2"><?php echo esc_html($about_us_content); ?></p>
		<?php endif; ?>
	    </div>
	    <div class="video">
		<?php
		if (!empty($video_link)):
		    $video_bg_image = wp_get_attachment_url($video_bg_img);
		    ?>
    		<img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($video_bg_image), '960', '745'); ?>" alt="<?php echo esc_attr($video_bg_image[0]); ?>" data-video="<?php echo esc_html($video_link); ?>" />
		<?php endif; ?>
		<div class="control">
		    <a href="#"><i class="fa fa-play"></i></a>
		</div>
	    </div>
	</div>

    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_about_us'));
