<?php
/**
 * Forever Wedding - Theme setup
 * It has theme setup functionality
 *  
 * @package foreverwedding
 * @subpackage foreverwedding.inc
 * @since foreverwedding 1.0.0
 */


/**
 * ForeverWedding - basic setup 
 * @since foreverwedding 1.0.0
 */
function foreverwedding_basic_setup() {

    //translation  
    load_theme_textdomain('foreverwedding', get_template_directory() . '/languages');

    //feed link
    add_theme_support('automatic-feed-links');

    //title tag
    add_theme_support('title-tag');

    //faetured images
    add_theme_support('post-thumbnails');

    //post formats
    add_theme_support('post-formats', array('gallery', 'image', 'quote', 'video', 'audio'));

    //comment form html5
    add_theme_support('html5', array('caption', 'comment-form', 'comment-list'));

    //register navigation menu 
    register_nav_menus(array(
        'primary_navigation' => esc_html__('Primary Navigation', 'foreverwedding'),       
        'primary_menu_two' => esc_html__('Primary Menu Two', 'foreverwedding'),
        'footer_menu' => esc_html__('Footer Menu', 'foreverwedding'),
    ));
}
add_action('after_setup_theme', 'foreverwedding_basic_setup');

/**
 * Forever Wedding - advance setup 
 * @since foreverwedding 1.0.0
 */
function foreverwedding_advance_setup() {

    //hide revslider update error
    update_option('revslider-valid', 'true');
    
    update_option( 'wp_job_manager_version', '1.23.13' );

    //content width
    $GLOBALS['content_width'] = $content_width = 474;

    //exceptions
    add_theme_support('custom-header');
    remove_theme_support('custom-header');

    add_theme_support('custom-background');
    remove_theme_support('custom-background');

    add_editor_style();
    remove_editor_styles();
}
add_action('after_setup_theme', 'foreverwedding_advance_setup');




/* ---------------------------------------------------
 * 
 *        ForeverWedding THEME FALLBACK : WP >= 4.4
 * 
 * --------------------------------------------------- */

//Theme fallback
if (!version_compare(get_bloginfo('version'), '4.4', '>=')) {
    add_action('after_switch_theme', 'foreverwedding_switch_theme');
    add_action('template_redirect', 'foreverwedding_preview_warning');
}


/**
 * Forever Wedding - switch theme
 * @since foreverwedding 1.0.0
 */
function foreverwedding_switch_theme() {
    switch_theme(WP_DEFAULT_THEME, WP_DEFAULT_THEME);
    unset($_GET['activated']);
    add_action('admin_notices', 'foreverwedding_upgrade_notice');
}

/**
 * ForeverWedding - upgrade notice
 * @since foreverwedding 1.0.0
 */
function foreverwedding_upgrade_notice() {
    $message = sprintf(esc_html__('ForeverWedding requires at least WordPress version 4.4 You are running version %s. Please upgrade and try again.', 'foreverwedding'), $GLOBALS['wp_version']);
    printf('<div class="error"><p>%s</p></div>', $message);
}

/**
 * ForeverWedding - theme redirect
 * @since foreverwedding 1.0.0
 */
function foreverwedding_preview_warning() {
    if (isset($_GET['preview'])) {
        wp_die(sprintf(esc_html__('ForeverWedding requires at least WordPress version 4.4 You are running version %s. Please upgrade and try again.', 'foreverwedding'), $GLOBALS['wp_version']));
    }
}


