<?php
/**
 * ForeverWedding - Post load functinality
 *  
 * @package foreverwedding
 * @subpackage foreverwedding/inc
 * @version 1.0.0
 */
add_action("wp_ajax_fw_blog_posts", "foreverwedding_gallery_posts");
add_action("wp_ajax_nopriv_fw_blog_posts", "foreverwedding_gallery_posts");

function foreverwedding_gallery_posts() {
    global $post;

    
    $listedposts = $_POST['listedposts']; // offsets in int
    $per_page=4;
    
    $args = array(
        'post_type' => 'gallery',
        'post_status' => 'publish',
        'posts_per_page' => $per_page,
        'order' => 'ASC',
        'offset' => $listedposts
    );

    $galleries = get_posts($args);

    if (count($galleries) > 0):
        foreach ($galleries as $gallery):

            //included category
            $terms = get_the_terms($gallery->ID, 'gallery_category');
            $term_class ='';
            if (count($terms) > 0):
                foreach ($terms as $term):
                    $term_class = ' '.$term->slug;
                endforeach;
            endif;

            $gallery_thumb = wp_get_attachment_url(get_post_thumbnail_id($gallery->ID), 'full');
            if (!empty($gallery_thumb)):
                ?>
                <li class="main-item all <?php echo esc_attr($term_class); ?>">
                    <a  class="fancybox-button" data-fancybox-group="fancybox-button" href="<?php echo esc_url($gallery_thumb); ?>" title="<?php echo esc_attr($gallery->post_title); ?>">  
                        <img src="<?php echo esc_url($gallery_thumb); ?>" alt="<?php echo esc_attr($gallery->post_title); ?>" title="<?php echo esc_attr($gallery->post_title); ?>"/>
                    </a>
                </li>
                <?php
            endif;
        endforeach;
    endif;

    die();
}
