<?php

/**
 * Forever Wedding - Social Share
 *
 * @package foreverwedding
 * @subpackage foreverwedding.inc.options.field
 * @since foreverwedding 1.0
 */

return array( 
 	array(
        'id'          => 'social_share_on_off',
        'label'       => esc_html__( 'Social Share On/Off', 'foreverwedding' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'foreverwedding_social_share_section',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
	array(
        'id'          => 'foreverwedding_social_share',
        'label'       => esc_html__( 'Social Share', 'foreverwedding' ),
        'desc'        => esc_html__( 'Social Share', 'foreverwedding' ),
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'foreverwedding_social_share_section',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'social_share_on_off:not(off)',
        'operator'    => 'and',
        'settings'    => array( 
          array(
            'id'          => 'class',
            'label'       => esc_html__( 'Icon Class', 'foreverwedding' ),
            'desc'        => esc_html__( 'font awesome icons class', 'foreverwedding' ),
            'std'         => '',
            'type'        => 'text',
            'operator'    => 'and'
          ),
          array(
            'id'          => 'background-color',
            'label'       => esc_html__( 'Icon Background Color', 'foreverwedding' ),
            'desc'        => '',
            'std'         => '',
            'type'        => 'colorpicker',
            'operator'    => 'and'
          ),
          array(
            'id'          => 'link',
            'label'       => esc_html__( 'Link', 'foreverwedding' ),
            'desc'        => esc_html__( 'Use URL listed Below', 'foreverwedding' ),
            'std'         => '',
            'type'        => 'text',
            'operator'    => 'and'
          )
        )
      ),
	array(
        'id'          => 'foreverwedding_social_share_info',
        'label'       => esc_html__( 'URLs For Sharing', 'foreverwedding' ),
        'desc'        => esc_html__( '<pre style="padding: 15px;">
Twitter
http://twitter.com/home?status=[TITLE]+[URL]

Digg
http://www.digg.com/submit?phase=2&url=[URL]&title=[TITLE]

Facebook
http://www.facebook.com/share.php?u=[URL]&title=[TITLE]

StumbleUpon
http://www.stumbleupon.com/submit?url=[URL]&title=[TITLE]

Delicious
http://del.icio.us/post?url=[URL]&title=[TITLE]]&notes=[DESCRIPTION]

Google Buzz
http://www.google.com/reader/link?title=[TITLE]&url=[URL]

Google Plus
https://plus.google.com/share?url=[URL]

Linkedin
http://www.linkedin.com/shareArticle?mini=true&url=[URL]&title=[TITLE]&source=[SOURCE/DOMAIN]

Slashdot
http://slashdot.org/bookmark.pl?url=[URL]&title=[TITLE]

Technorati
http://technorati.com/faves?add=[URL]&title=[TITLE]

Posterous
http://posterous.com/share?linkto=[URL]

Tumblr
http://www.tumblr.com/share?v=3&u=[URL]&t=[TITLE]

Reddit
http://www.reddit.com/submit?url=[URL]&title=[TITLE]

Google Bookmarks
http://www.google.com/bookmarks/mark?op=edit&bkmk=[URL]&title=[title]&annotation=[DESCRIPTION]

Newsvine
http://www.newsvine.com/_tools/seed&save?u=[URL]&h=[TITLE]

Ping.fm
http://ping.fm/ref/?link=[URL]&title=[TITLE]&body=[DESCRIPTION]

Evernote
http://www.evernote.com/clip.action?url=[URL]&title=[TITLE]

Friendfeed
http://www.friendfeed.com/share?url=[URL]&title=[TITLE]
</pre>', 'foreverwedding' ),
        'std'         => '',
        'type'        => 'textblock-titled',
        'section'     => 'foreverwedding_social_share_section',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'social_share_on_off:not(off)',
        'operator'    => 'and'
      ),
);
