<?php 
/**
 * ForeverWedding - Our Success Story metabox
 *
 * @package  foreverwedding
 * @subpackage  foreverwedding/inc/metabox
 * @version 1.0.0
 */
class ForeverWedding_Success_Meta {

    public function __construct() {
        $this->action();
    }

    function action() {
        add_filter("foreverwedding_post_register", array(&$this, "successMeta"));
    }

    /**
     * Forever Wedding Metabox
     * @param type $args
     * @return string
     */
    function successMeta($args) {
        $args[] = array(
            'id' => 'success_boxes',
            'title' => esc_html__('Success Story', 'foreverwedding'),
            'desc' => '',
            'pages' => array('story'),
            'context' => 'normal',
            'priority' => 'high',
            'fields' => array(
				array(
                    'id' => 'success_story_date',
                    'label' => esc_html__('Enter Story Date', 'foreverwedding'),
                    'desc' => esc_html__('Enter Story Date.', 'foreverwedding'),
                    'type' => 'text',
                    'class' => '',
                ),
                array(
                    'id' => 'success_story_images',
                    'label' => esc_html__('Images', 'foreverwedding'),
                    'desc' => esc_html__('Images', 'foreverwedding'),
                    'std' => '',
                    'type' => 'list-item',
                    'settings' => array(
                        array(
                            'id' => 'success_image',
                            'label' => esc_html__('Upload Image', 'foreverwedding'),
                            'desc' => esc_html__('Upload Image', 'foreverwedding'),
                            'std' => '',
                            'type' => 'upload'
                        )
                        
                    )
                ),
            )
        );
        return $args;
    }

}

new ForeverWedding_Success_Meta();
