<?php

/**
 * ForeverWedding - Metaboxes (Post & category) 
 *
 * @package     foreverwedding
 * @subpackage     foreverwedding/inc/metabox
 * @version 1.0.0
 */
class ForeverWedding_Metabox {

    public function __construct() {
        //add metabox
        add_filter("ot_post_formats", '__return_true');
        $this->loadMetabox();
        add_action("admin_init", array(&$this, 'registerMeta'));
        //ot format audio
        add_filter('ot_meta_box_post_format_audio', array(&$this, 'audio_format'));
        add_filter('ot_meta_box_post_format_quote', array(&$this, 'quote_format'));
    }

    /**
     * Register Metabox
     */
    function registerMeta() {
        $args = apply_filters("foreverwedding_post_register", array());

        if (count($args) > 0):
            foreach ($args as $arg):
                ot_register_meta_box($arg);
            endforeach;
        endif;
    }

    function loadMetabox() {
		require_once trailingslashit( get_template_directory() ).'/inc/metabox/success-story.php';
		require_once trailingslashit( get_template_directory() ).'/inc/metabox/wedding-event.php';
		require_once trailingslashit( get_template_directory() ).'/inc/metabox/hotels-metabox.php';
    }

    /**
     * Forever Wedding - Audio Format
     * 
     * @param array $args
     * @return array $args
     */
    function audio_format($args) {
        $args['fields'] = array();
        $args['fields'][] = array(
            'id' => '_format_audio_mp3',
            'label' => '',
            'desc' => sprintf(esc_html__('Upload .mp3 File.', 'foreverwedding')),
            'std' => '',
            'type' => 'upload'
        );
        $args['fields'][] = array(
            'id' => '_format_audio_ogg',
            'label' => '',
            'desc' => sprintf(esc_html__('Upload .ogg File.', 'foreverwedding')),
            'std' => '',
            'type' => 'upload'
        );
        $args['fields'][] = array(
            'id' => '_format_audio_wav',
            'label' => '',
            'desc' => sprintf(esc_html__('Upload .wav File.', 'foreverwedding')),
            'std' => '',
            'type' => 'upload'
        );
        return $args;
    }

    /**
     * Forever Wedding - Quote Format
     *  
     * @param array $args
     * @return array $args
     */
    function quote_format($args) {
        return array(
            'id' => 'ot-post-format-quote',
            'title' => esc_html__('Quote', 'foreverwedding'),
            'desc' => '',
            'pages' => 'post',
            'context' => 'side',
            'priority' => 'low',
            'fields' => array(
                array(
                    'id' => '_format_quote',
                    'label' => '',
                    'desc' => esc_html__('Quote', 'foreverwedding'),
                    'std' => '',
                    'type' => 'textarea'
                ),
            )
        );
    }

}

new ForeverWedding_Metabox();
