<?php 
/**
 * ForeverWedding - Wedding Hotel metabox
 *
 * @package foreverwedding
 * @subpackage foreverwedding/inc/metabox
 * @version 1.0.0
 */
class ForeverWedding_Hotel_Meta {

    public function __construct() {
        $this->action();
    }

    function action() {
        add_filter("foreverwedding_post_register", array(&$this, "hotelMeta"));
    }

    /**
     * Forever Wedding Metabox
     * @param type $args
     * @return string
     */
    function hotelMeta($args) {
        $args[] = array(
            'id' => 'hotel_boxes',
            'title' => esc_html__('Wedding Event', 'foreverwedding'),
            'desc' => '',
            'pages' => array('hotels'),
            'context' => 'normal',
            'priority' => 'high',
            'fields' => array(
		array(
                    'id' => 'latitude',
                    'label' => esc_html__('Enter hotel latitude', 'foreverwedding'),
                    'desc' => esc_html__('Enter hotel latitude.', 'foreverwedding'),
                    'type' => 'text',
                    'class' => '',
                ),
		array(
                    'id' => 'longitude',
                    'label' => esc_html__('Enter hotel longitude', 'foreverwedding'),
                    'desc' => esc_html__('Enter hotel longitude.', 'foreverwedding'),
                    'type' => 'text',
                    'class' => '',
                ),
                 
		array(
                    'id' => 'address',
                    'label' => esc_html__('Enter hotel address', 'foreverwedding'),
                    'desc' => esc_html__('Enter hotel address.', 'foreverwedding'),
                    'type' => 'text',
                    'class' => '',
                ),
		array(
                    'id' => 'phone',
                    'label' => esc_html__('Enter hotel phone no.', 'foreverwedding'),
                    'desc' => esc_html__('Enter hotel phone nol.', 'foreverwedding'),
                    'type' => 'text',
                    'class' => '',
                ),
		array(
                    'id' => 'site_link',
                    'label' => esc_html__('Enter hotel site URL.', 'foreverwedding'),
                    'desc' => esc_html__('Enter hotel site URL.', 'foreverwedding'),
                    'type' => 'text',
                    'class' => '',
                ),
            )
        );
        return $args;
    }

}

new ForeverWedding_Hotel_Meta();
