<?php 
/**
 * ForeverWedding - Comment
 * 
 * This page has comment list callback functionality
 *  
 * @package foreverwedding
 * @subpackage foreverwedding/inc
 * @version 1.0.0
 */
function foreverwedding_comment($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    switch ($comment->comment_type) :
        case 'pingback' :
        case 'trackback' :
            // Display trackbacks differently than normal comments.
            ?>
            <li <?php comment_class('blog-post-comment-sec'); ?> id="comment-<?php comment_ID(); ?>">
                <p><?php esc_html_e('Pingback:', 'foreverwedding'); ?> <?php comment_author_link(); ?> <?php edit_comment_link(esc_html__('(Edit)', 'foreverwedding'), '<span class="edit-link">', '</span>'); ?></p>
                <?php
                break;
            default :
                // Proceed with normal comments.
                global $post;
                ?>

            <li <?php comment_class('blog-post-comment-sec'); ?> id="comment-<?php comment_ID(); ?>">
                <div class="comment-box-wrapper media clearfix">
                    <div class="left-img-blog-box media-left media-middle">
                        <figure class="round-img-wrapper"><?php echo get_avatar($comment, 99); ?></figure>
                    </div>
                    <div class="comment-wrap text-right-blog commenter-info-1 media-body">
                        <div class="media-heading-wrpper clearfix">
                        	<strong class="name media-heading emma"><?php comment_author(); ?></strong><span class="posted-date timing-class"><?php echo get_comment_date('d  F  Y'); ?>, <?php echo get_comment_time(); ?></span>
                        </div>

                        <?php if ('0' == $comment->comment_approved) : ?>
                            <p class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.', 'foreverwedding'); ?></p>
                        <?php endif; ?>
                        <section class="comment-content">
                            <?php comment_text(); ?>
                            <span class="edit-reply-link reply-btn comm-back-btn rply-class">
                                <?php edit_comment_link(esc_html__('Edit', 'foreverwedding')); ?>
                                <?php comment_reply_link(array_merge($args, array('reply_text' => esc_html__('Reply', 'foreverwedding'), 'after' => '', 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
                            </span>
                        </section><!-- .comment-content -->
                    </div>
                    <div class="clear">&nbsp;</div>
                </div>
                <?php
                break;
        endswitch; // end comment_type check
    }

    function foreverwedding_comment_form_before() {
        echo '<section class="contact-from"><div class="form-wrap">';
    }

    function foreverwedding_comment_form_after() {
        echo '</div><div class="col-xs-12 triangle-img">';
       
        echo '</div></section>';
    }

    add_action('comment_form_before', 'foreverwedding_comment_form_before');
    add_action('comment_form_after', 'foreverwedding_comment_form_after');
    
