<?php
/**
 * Forever Wedding - video format
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.content.format
 * @since foreverwedding 1.0.0
 */
global $foreverwedding_single;

if ($foreverwedding_single == 'single'):
    ?>
    <div <?php post_class('row'); ?>>
        <article class="blog-post-wrapper">
            <?php if (is_sticky()): ?>
                <span class="stick-pin"><i class="fa fa-thumb-tack"></i></span>
                <?php
            endif;
            
            $foreverwedding_url = wp_get_attachment_url(get_post_thumbnail_id()); 
            $foreverwedding_video = get_post_meta(get_the_ID(), '_format_video_embed', true);
            $foreverwedding_category = get_the_category();
            
            ?>
            <?php if (!empty($foreverwedding_url)) { ?>
                <figure class="video">
                    <img src="<?php echo apply_filters('foreverwedding_image_resize', $foreverwedding_url, '1043', '408'); ?>"  alt="" data-video="<?php echo wp_kses_post($video); ?>"  />
                    <div class="control">
                        <a href="#"><i class="fa fa-play"></i></a>
                    </div>
                </figure>
            <?php } else { ?>
                <figure class="video videosection">
                    <if<?php ?>rame src="<?php echo esc_url($foreverwedding_video) ?>"></if<?php ?>rame>
                </figure>
            <?php } ?>
            <div class="post-blog blog-single-quotes">
                <?php if (!is_page()): ?>	
                    <?php $foreverwedding_category = get_the_category(); ?>					
                    <span class="timing-blog"><a href="<?php echo get_month_link(get_the_time('Y'), get_the_time('m')); ?>"><i class="fa fa-calendar"> </i> <span><?php echo get_the_date('F d , Y'); ?></span></a>  
                        <?php echo apply_filters('foreverwedding_category_filter', get_the_ID()); ?></span>
                    <?php
                endif;
                $foreverwedding_flag = false;
                if ($foreverwedding_flag) {
                    the_tags('<ul><li>', '</li><li>', '</li></ul>');
                }
                ?>
                <h2><a href="<?php the_permalink(); ?>"><?php $foreverwedding_post_title=get_the_title(); (!empty($foreverwedding_post_title) ? the_title() : esc_html_e('untitled','foreverwedding'));?></a></h2>
                <?php
                if (is_search()):
                    the_excerpt();
                else:
                    the_content();
                    $post_content = get_post_field('post_content', get_the_ID());
		    if (1 < strpos($post_content, '<!--more-->') && !is_single()) {
			?>
	    	    <a href="<?php the_permalink(); ?>" class="btn btn-default"><?php echo esc_html_e('read more', 'foreverwedding'); ?> <i class="fa fa-angle-right"></i></a>
		    <?php } ?>
		    <?php wp_link_pages();
                endif;
                ?>
                <?php do_action('foreverwedding_post_share'); ?>
            </div>
        </article>
    </div>
<?php else: ?>

    <div <?php post_class('row'); ?>>
        <article class="blog-post-wrapper">
            <?php if (is_sticky()): ?>
                <span class="stick-pin"><i class="fa fa-thumb-tack"></i></span>
                <?php
            endif;
            ?>
            <?php $foreverwedding_url = wp_get_attachment_url(get_post_thumbnail_id()); 
            $foreverwedding_video = get_post_meta(get_the_ID(), '_format_video_embed', true);
            $foreverwedding_category = get_the_category();
            if (!empty($foreverwedding_url)) { 
                ?>
                <figure class="video">
                    <img src="<?php echo apply_filters('foreverwedding_image_resize', $foreverwedding_url, '1043', '408'); ?>"  alt="" data-video="<?php echo wp_kses_post($foreverwedding_video); ?>"  />
                    <div class="control">
                        <a href="#"><i class="fa fa-play"></i></a>
                    </div>
                </figure>
            <?php } elseif ($foreverwedding_video != '') { ?>
                <figure class="video videosection">
                    <if<?php ?>rame src="<?php echo esc_url($foreverwedding_video) ?>"></if<?php ?>rame>
                </figure>
            <?php } ?>
            <div class="post-blog">	
                <?php $foreverwedding_category = get_the_category(); ?>					
                <span class="timing-blog"><a href="<?php echo get_month_link(get_the_time('Y'), get_the_time('m')); ?>"><i class="fa fa-calendar"> </i> <span><?php echo get_the_date('F d , Y'); ?></span></a>  
                    <?php echo apply_filters('foreverwedding_category_filter', get_the_ID()); ?></span>
                <?php
                $foreverwedding_flag = false;
                if ($foreverwedding_flag) {
                    the_tags('<ul><li>', '</li><li>', '</li></ul>');
                }
                ?>
                <h2><a href="<?php the_permalink(); ?>"><?php $foreverwedding_post_title=get_the_title(); (!empty($foreverwedding_post_title) ? the_title() : esc_html_e('untitled','foreverwedding'));?></a></h2>
                <?php
                if (is_search()):
                    the_excerpt();
                else:
                    the_content();
                    $post_content = get_post_field('post_content', get_the_ID());
		    if (1 < strpos($post_content, '<!--more-->') && !is_single()) {
			?>
	    	    <a href="<?php the_permalink(); ?>" class="btn btn-default"><?php echo esc_html_e('read more', 'foreverwedding'); ?> <i class="fa fa-angle-right"></i></a>
		    <?php } ?>
		    <?php wp_link_pages();
                endif;
                ?>
       
            </div>
        </article>
    </div>
<?php endif; 