<?php

/**
 * Forever Wedding - What We Do Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
 
  function ForeverWedding_select_page() {
    $pages = array();
    $page_list = get_posts(array('post_type' => 'page', 'post_status' => 'publish', 'posts_per_page' => -1));
    if (count($page_list) > 0) {
        foreach ($page_list as $page) {
            $pages[] = array(
                'value' => $page->ID,
                'label' => $page->post_title
            );
        }
    }
    return $pages;
}
 
add_action('vc_before_init', 'foreverwedding_what_we_do');

function foreverwedding_what_we_do() {
    vc_map(array(
        "name" => esc_html__("Foreverwedding what we do section", 'foreverwedding'),
        "base" => "foreverwedding_what_we_do",
        "class" => "",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
	"icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Title", 'foreverwedding'),
                "param_name" => "inner_title",
                "value" => '',
                "description" => esc_html__("Enter section title", 'foreverwedding')
            ),
            array(
                "type" => "textarea",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("What We Do Content", 'foreverwedding'),
                "param_name" => "what_we_do_content",
                "value" => '',
                "description" => esc_html__("Enter What We Do Content Here.", 'foreverwedding')
            ),
            array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "what_do_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                array(
                        'type' => 'attach_image',
                        'value' => '',
                        'heading' => 'Upload Event Image',
                        'param_name' => 'event_image',
                    ),
                    array(
                        'type' => 'iconpicker',
                        'value' => '',
                        'heading' => 'Select Icon',
                        'param_name' => 'class_name',
                        "description" => esc_html__("Select Icon here", 'foreverwedding')
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Event title',
                        'param_name' => 'event_title',
                    ),
                    array(
                        'type' => 'dropdown',
                        'value' => ForeverWedding_select_page(),
                        'heading' => 'Select Page Link',
                        'param_name' => 'event_title_link',
                    ),
                   array(
                        "type" => "textarea",
                        "holder" => "",
                        "class" => "",
                        "heading" => esc_html__("Event Content", 'foreverwedding'),
                        "param_name" => "event_content",
                        "value" => '',
                        "description" => esc_html__("Enter event content here", 'foreverwedding')
                    ),
                ),
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_what_we_do extends WPBakeryShortCode { }
