<?php

/**
 * Forever Wedding - Recent Posts Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_recent_posts');

function foreverwedding_recent_posts() {
    vc_map(array(
        "name" => esc_html__("Foreverwedding recent post section", 'foreverwedding'),
        "base" => "foreverwedding_recent_posts",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Title", 'foreverwedding'),
                "param_name" => "inner_title",
                "value" => '',
                "description" => esc_html__("Enter section title", 'foreverwedding')
            ),
             array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("No. of post", 'foreverwedding'),
                "param_name" => "post_no",
                "value" => '',
                "description" => esc_html__("Enter number of post", 'foreverwedding')
            ),
             array(
                "type" => "dropdown",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Ascending/Decending order", 'foreverwedding'),
                "param_name" => "order_no",
                "value"       => array(
								        'Ascending order'   => 'ASC',
								        'Decending order'   => 'DESC',
								      ),
                "description" => esc_html__("Enter Ascending/Decending order", 'foreverwedding')
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_recent_posts extends WPBakeryShortCode { }
