<?php

/**
 * Forever Wedding - Brand Ticker Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_brand_ticker');

function foreverwedding_brand_ticker() {
    vc_map(array(
        "name" => esc_html__("Forever Wedding Brand Ticker", 'foreverwedding'),
        "base" => "foreverwedding_brand_ticker",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
        array(
                "type" => "colorpicker",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Background Color", 'foreverwedding'),
                "param_name" => "bg_color",
                "value" => '',
                "description" => esc_html__("Enter background color here.", 'foreverwedding')
            ),
        	array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Title", 'foreverwedding'),
                "param_name" => "title",
                "value" => '',
                "description" => esc_html__("Enter section title", 'foreverwedding')
            ),
            array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "brand_ticker_section_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                array(
                        'type' => 'attach_image',
                        'value' => '',
                        'heading' => 'Upload Image',
                        'param_name' => 'brand_ticker_image',
                    ),
                ),
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_brand_ticker extends WPBakeryShortCode { }
