<?php
/**
 * Forever Wedding - Our Team Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'inner_title' => '',
    'our_team_section_repeater' => '',
		), $atts));
?>
<div class="home-agency">
    <section class="our-team">
	<div class="container">
	    <div class="row">
		<div class="info-wrap">
		    <?php if (!empty($inner_title)): ?>
    		    <h2><?php echo esc_html($inner_title); ?></h2>
		    <?php endif; ?>
		</div>
		<div class="team-slider" dir="ltr">
		    <?php
		    $our_team_section_repeater = vc_param_group_parse_atts($atts['our_team_section_repeater']);
		    if (!empty($our_team_section_repeater) && is_array($our_team_section_repeater)):
			foreach ($our_team_section_repeater as $team_section_repeater):
			    ?>	
			    <div class="item">
				<div class="group">
				    <?php
				    if (isset($team_section_repeater['team_image'])):
					$team_image = wp_get_attachment_url($team_section_repeater['team_image']);
					if (!empty($team_image)) {
					    ?> 
					    <figure><img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($team_image), '370', '432'); ?>" alt="<?php echo esc_attr($team_section_repeater['team_image']); ?>" title="<?php echo esc_attr($team_section_repeater['team_image']); ?>" /></figure>
					    <?php
					}
				    endif;
				    ?> 	
				    <div class="detail">
					<?php
					if (isset($team_section_repeater['team_member_name'])):
					    $team_member_name = $team_section_repeater['team_member_name'];
					    if (!empty($team_member_name)) {
						?> 
						<h3><a href="javascript:void(0);"><?php echo esc_html($team_member_name); ?></a></h3>
					    <?php } endif; ?> 
					<?php
					if (isset($team_section_repeater['team_member_designation'])):
					    $team_member_designation = $team_section_repeater['team_member_designation'];
					    if (!empty($team_member_designation)) {
						?> 
						<span><?php echo esc_html($team_member_designation); ?></span> 
					    <?php } endif; ?>
					<?php if (isset($team_section_repeater['team_member_views'])): ?>
	    				<p><?php echo wp_kses($team_section_repeater['team_member_views'], wp_kses_allowed_html('post')); ?></p>
					<?php endif; ?> 
					<?php
					if (isset($team_section_repeater['twitter'])):
					    $twitter = $team_section_repeater['twitter'];
					    if (!empty($twitter)) {
						?> 
						<a href="<?php echo esc_url($twitter); ?>"><i class="fa fa-twitter"></i></a>
					    <?php } endif; ?> 
					<?php
					if (isset($team_section_repeater['facebook'])):
					    $facebook = $team_section_repeater['facebook'];
					    if (!empty($facebook)) {
						?> 
						<a href="<?php echo esc_url($facebook); ?>"><i class="fa fa-facebook"></i></a>
					    <?php } endif; ?> 
					<?php
					if (isset($team_section_repeater['google_plus'])):
					    $google_plus = $team_section_repeater['google_plus'];
					    if (!empty($google_plus)) {
						?> 
						<a href="<?php echo esc_url($google_plus); ?>"><i class="fa fa-google-plus"></i></a>
					    <?php } endif; ?> 
					<?php
					if (isset($team_section_repeater['linkedin'])):
					    $linkedin = $team_section_repeater['linkedin'];
					    if (!empty($linkedin)) {
						?> 
						<a href="<?php echo esc_url($linkedin); ?>"><i class="fa fa-linkedin"></i></a>
						<?php } endif; ?> 
				    </div>
				</div>
			    </div>
			    <?php
			endforeach;
		    endif;
		    ?> 
		</div>
	    </div>
	</div>
    </section>
</div>
<?php
echo ($this->endBlockComment('foreverwedding_our_team'));
