<?php
/**
 * Forever Wedding - our success story
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => '',
		), $atts));
?>  
<section class="our-success-Story">
    <div class="container">
	<div class="row">
	    <div class="col-xs-12">
		<?php if (!empty($title)): ?>
    		<div class="header-center">
    		    <h2><?php echo esc_html($title); ?></h2>
    		</div><?php endif; ?>
		<div class="timeline-scale"></div>
		<div class="left-right-wrapper clearfix">
		    <span class="time-line-divider"> </span>
		    <div class="left-section-content clearfix">
			<?php
			$args = array(
			    'post_type' => 'story',
			    'post_status' => 'publish',
			    'order' => 'ASC',
			    'posts_per_page' => -1,
			);

			$story_query = new WP_Query($args);
			$count = 1;
			$class = '';
			if ($story_query->have_posts()) :
			    while ($story_query->have_posts()) : $story_query->the_post();

				if ($count % 2 == 0) {
				    $class = 'even';
				} else {
				    $class = 'odd';
				}
				?>
				<article class="met-section <?php echo esc_attr($class); ?>">
				    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
				    <div class="arrow-cls">
					<span class="css-shape"><?php echo esc_html(get_post_meta(get_the_ID(), 'success_story_date', true)); ?></span>
				    </div>
				    <?php
				    $svg_id = get_post_meta(get_the_id(), 'story_select_svg', true);
				    if (has_post_thumbnail($svg_id)) :
					$src = wp_get_attachment_url(get_post_thumbnail_id($svg_id), 'full');
					?> 
	    			    <figure>  <img src="<?php echo esc_url($src); ?>" alt="<?php echo esc_attr(get_the_title($svg_id)); ?>" title="<?php echo esc_attr(get_the_title($svg_id)); ?>"/></figure>
					<?php
				    endif;
				    ?>
				    <?php
				    $story_images = get_post_meta(get_the_ID(), 'success_story_images', true);
				    if (!empty($story_images) && is_array($story_images)):
					?>
	    			    <ul class="clearfix">
					    <?php foreach ($story_images as $img) : ?>
						<li>
						    <img src="<?php echo esc_url($img['success_image']); ?>" alt="">
						</li>
					    <?php endforeach; ?>	
	    			    </ul> 
					<?php
				    endif;
				    ?>		
				    <?php the_content(); ?>
				    <a class="read-more" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'foreverwedding'); ?> <i class="fa fa-angle-right"></i></a>
				</article>
				<?php
				$count++;
			    endwhile;
			endif;
			wp_reset_postdata();
			?>
		    </div>
		</div>
	    </div>
	</div>
    </div>
</section>
<?php
echo ($this->endBlockComment('foreverwedding_our_success_story'));
