<?php
/**
 * Forever Wedding - Friends Wishes Section
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'title' => esc_html__('Friends Wishes', 'foreverwedding'),
    'friends_wishes_section_repeater' => '',
		), $atts));
?>
<section class="friend-wishes">
    <div class="container">
	<div class="row">
	    <?php if (!empty($title)): ?>
    	    <div class="header-center">
    		<h2><?php echo esc_html($title); ?></h2>
    	    </div><?php endif; ?>
	</div>					
	<div class="wishes clearfix">
	    <div class="row">
		<div class="people-thought" dir="ltr">
		    <?php
		    $friends_wishes_section_repeater = vc_param_group_parse_atts($atts['friends_wishes_section_repeater']);
		    if (!empty($friends_wishes_section_repeater) && is_array($friends_wishes_section_repeater)):
			foreach ($friends_wishes_section_repeater as $wishes_section_repeater):
			    ?>	
			    <div class="item">
				<div class="quoto">
				    <div class="para-wrapper">
					<?php if (isset($wishes_section_repeater['wishes_content'])): ?>
	    				<p><?php echo wp_kses($wishes_section_repeater['wishes_content'], wp_kses_allowed_html('post')); ?></p>
					<?php endif; ?> 
				    </div>
				    <div class="overlay clearfix">
					<?php
					if (isset($wishes_section_repeater['friend_image'])):
					    $friend_image = wp_get_attachment_url($wishes_section_repeater['friend_image']);
					    if (!empty($friend_image)) {
						?> 
						<figure><img src="<?php echo apply_filters('foreverwedding_image_resize', esc_url($friend_image), '68', '67'); ?>" alt="<?php echo esc_attr($wishes_section_repeater['friend_image']); ?>" title="<?php echo esc_attr($wishes_section_repeater['friend_image']); ?>" /></figure>
						<?php
					    }
					endif;
					?> 	
					<span class="profile-info"> 
					    <?php
					    if (isset($wishes_section_repeater['friend_name'])):
						$friend_name = $wishes_section_repeater['friend_name'];
						if (!empty($friend_name)) {
						    ?> 
						    <strong><?php echo esc_html($friend_name); ?></strong> 
						<?php } endif; ?> 

					    <?php
					    if (isset($wishes_section_repeater['friend_relation'])):
						$friend_relation = $wishes_section_repeater['friend_relation'];
						if (!empty($friend_relation)) {
						    ?> 
						    <span><?php echo esc_html($friend_relation); ?></span> 
						<?php } endif; ?> 
					</span>
				    </div>
				</div>
			    </div>
			    <?php
			endforeach;
		    endif;
		    ?> 
		</div>
	    </div>
	</div>
    </div>					
</section>
<?php
echo ($this->endBlockComment('foreverwedding_friends_wishes'));
