<?php
/**
 * Forever Wedding - event content
 *
 * This template is use by js composer plugin
 *
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
extract(shortcode_atts(array(
    'event_address' => '',
    'event_date' => '',
    'event_time' => '',
		), $atts));
?> 
<!-- about us section start here -->
<div class="event-page-content">
    <div class="container">
	<div class="row">
	    <div class="col-xs-12 col-sm-4">
		<div class="span-wrapper">
		    <a href="#"><i class="fa fa-map-marker"></i></a>
		    <?php if (!empty($event_address)): ?>
    		    <span class="village-class"><?php echo esc_html($event_address); ?></span>
		    <?php endif; ?>									
		</div>
	    </div>
	    <div class="col-xs-12 col-sm-4">
		<div class="span-wrapper">
		    <a href="#"><i class="fa fa-calendar"></i></a>
		    <?php if (!empty($event_date)): ?>
    		    <span class="village-class"><?php echo esc_html($event_date); ?></span>
		    <?php endif; ?>	
		</div>
	    </div>
	    <div class="col-xs-12 col-sm-4">
		<div class="span-wrapper">
		    <a href="#"><i class="fa fa-clock-o"></i></a>
		    <?php if (!empty($event_time)): ?>
    		    <span class="village-class"><?php echo esc_html($event_time); ?></span>
		    <?php endif; ?>	
		</div>
	    </div>
	</div>
    </div>
</div>
<div id="map"></div>
<!-- about us section end here -->
<?php
echo ($this->endBlockComment('event_content'));
