<?php
/**
 * ForeverWedding -  Footer Widget 
 *  
 * @package foreverwedding
 * @subpackage foreverwedding/inc/widgets
 * @version 1.0.0
 */

/**
 * Adds Contact Widget widget.
 */
class ForeverWedding_Wedding_Footer_Widget extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    function __construct() {
        parent::__construct(
                'wedding_footer_widget', // Base ID
                esc_html__('Wedding Footer Widget', 'foreverwedding'), // Name
                array('description' => esc_html__('Wedding Footer Widget', 'foreverwedding'),) // Args
        );
        add_action('admin_enqueue_scripts', array($this, 'upload_scripts'));
    }

    /**
     * Upload the Javascripts for the media uploader
     */
    public function upload_scripts() {
        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');

        wp_enqueue_style('thickbox');
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance) {
        include_once ABSPATH . 'wp-admin/includes/plugin.php';
		echo wp_kses_post( $args['before_widget']);
        ?>
            <div class="footer-logo">
                <?php if (!empty($instance['image_uri'])) : ?>
                    <figure>
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($instance['image_uri']); ?>"  alt="<?php echo get_bloginfo('name'); ?>" title="<?php echo get_bloginfo('name'); ?>"  /></a>						
                    </figure>
                <?php endif; ?>

                <?php if (!empty($instance['title'])) : ?>
                    <h4><?php echo wp_kses_post($instance['title']); ?></h4>
                <?php endif; ?>

                <?php if (!empty($instance['f_description'])) : ?>
                    <span class="oct-class"><?php echo esc_html($instance['f_description']); ?></span>
                <?php endif; ?>

            </div>                 
        <?php
        echo wp_kses_post($args['after_widget']); 
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $f_description = !empty($instance['f_description']) ? $instance['f_description'] : '';
        $image_uri = !empty($instance['image_uri']) ? $instance['image_uri'] : '';
        ?>
        <p>
            <label for="<?php echo  esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'foreverwedding'); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('f_description')); ?>"><?php esc_html_e('Description:', 'foreverwedding'); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('f_description')); ?>" name="<?php echo esc_attr($this->get_field_name('f_description')); ?>" type="text" value="<?php echo esc_attr($f_description); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name('image_uri')); ?>"><?php esc_html_e('Image:', 'foreverwedding'); ?></label>
            <input name="<?php echo esc_attr($this->get_field_name('image_uri')); ?>" id="<?php echo esc_attr($this->get_field_id('image_uri')); ?>" class="widefat" type="text" size="36"  value="<?php echo esc_url($image_uri); ?>" />
            <input class="upload_image_button" type="button" value="Upload Image" />
        </p>
        <?php
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title']) ) ? $new_instance['title'] : '';
        $instance['f_description'] = (!empty($new_instance['f_description']) ) ? $new_instance['f_description'] : '';
        $instance['image_uri'] = (!empty($new_instance['image_uri']) ) ? $new_instance['image_uri'] : '';
        return $instance;
    }

}
