<?php

/**
 * ForeverWedding -  Search Widget 
 *  
 * @package foreverwedding
 * @subpackage foreverwedding/inc/widgets
 * @version 1.0.0
 */
class ForeverWedding_Widget_Search extends WP_Widget {

    public function __construct() {
        $widget_ops = array('classname' => 'foreverwedding_widget_search', 'description' => esc_html__("A search form for your site.", 'foreverwedding'));
        parent::__construct('foreverwedding_search', esc_html__('Forever Wedding Search', 'foreverwedding'), $widget_ops);
    }

    /**
     * @param array $args
     * @param array $instance
     */
    public function widget($args, $instance) {
        /** This filter is documented in wp-includes/default-widgets.php */
        $title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);

        echo wp_kses_post($args['before_widget']);
        if ($title) {
            echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
        }

        // Use current theme search form if it exists
        ?>
        <div class="search-blog">
            <form role="search" method="get" action="<?php echo home_url('/'); ?>">
                <div class="search-box">
                    <input type="text" value="<?php echo get_search_query() ?>" id="search-blog" placeholder="search" name="s" required>
                    <i class="fa fa-search"> </i>
                </div>
            </form>
        </div>
        <?php
        echo wp_kses_post($args['after_widget']);
    }

    /**
     * @param array $instance
     */
    public function form($instance) {
        $instance = wp_parse_args((array) $instance, array('title' => ''));
        $title = $instance['title'];
        ?>
        <p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'foreverwedding'); ?> <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></label></p>
        <?php
    }

    /**
     * @param array $new_instance
     * @param array $old_instance
     * @return array
     */
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $new_instance = wp_parse_args((array) $new_instance, array('title' => ''));
        $instance['title'] = strip_tags($new_instance['title']);
        return $instance;
    }

}
