<?php

/**
 * ForeverWedding -  Categories Widget 
 *  
 * @package foreverwedding
 * @subpackage foreverwedding/inc/widgets
 * @version 1.0.0
 */
class ForeverWedding_Recent_News extends WP_Widget {

    public function __construct() {
        $widget_ops = array('classname' => 'foreverwedding_widget_recent_entries', 'description' => esc_html__("Your site&#8217;s most recent Posts.", 'foreverwedding'));
        parent::__construct('foreverwedding-recent-posts', esc_html__('Forever Wedding Recent Posts', 'foreverwedding'), $widget_ops);
        $this->alt_option_name = 'foreverwedding_widget_recent_entries';
    }

    /**
     * @param array $args
     * @param array $instance
     */
    public function widget($args, $instance) {

        $title = (!empty($instance['title']) ) ? $instance['title'] : esc_html__('Recent Posts', 'foreverwedding');

        /** This filter is documented in wp-includes/default-widgets.php */
        $title = apply_filters('widget_title', $title, $instance, $this->id_base);

        $number = (!empty($instance['number']) ) ? absint($instance['number']) : 5;
        if (!$number)
            $number = 5;
        $show_date = isset($instance['show_date']) ? $instance['show_date'] : false;

        /**
         * Filter the arguments for the Recent Posts widget.
         *
         * @since 3.4.0
         *
         * @see WP_Query::get_posts()
         *
         * @param array $args An array of arguments used to retrieve the recent posts.
         */
        $r = new WP_Query(apply_filters('widget_posts_args', array(
                    'posts_per_page' => $number,
                    'no_found_rows' => true,
                    'post_status' => 'publish',
                    'ignore_sticky_posts' => true
        )));

        if ($r->have_posts()) :
             echo wp_kses_post($args['before_widget']); 
            if ($title) {
                echo wp_kses_post($args['before_title']) . $title . $args['after_title'];
            }
            ?>
            <ul class="blog-list-sidebar">
                <?php while ($r->have_posts()) : $r->the_post(); ?>

                    <li class="recent-post-wrapper">
                        <?php
                        $url = wp_get_attachment_url(get_post_thumbnail_id());
                        if (!empty($url)):
                            ?>
                            <figure>
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?php echo apply_filters('foreverwedding_image_resize', $url, '67', '67'); ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>">
                                </a>
                            </figure>
                        <?php endif;
                        ?>
                        <div class="recent-update">
                            <a href="<?php the_permalink(); ?>">

                                <div >
                                    <?php if ($show_date) : ?> <span><?php echo get_the_date('d F  Y'); ?></span> <?php endif; ?>
                                    <h4><?php get_the_title() ? the_title() : the_ID(); ?></h4>
                                </div>                               
                            </a>
                        </div>
                    </li>
                <?php endwhile; ?>
            </ul>
            <?php echo wp_kses_post($args['after_widget']); 
            // Reset the global $the_post as this query will have stomped on it
            wp_reset_postdata();

        endif;
    }

    /**
     * @param array $new_instance
     * @param array $old_instance
     * @return array
     */
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['show_date'] = isset($new_instance['show_date']) ? (bool) $new_instance['show_date'] : false;

        return $instance;
    }

    /**
     * @param array $instance
     */
    public function form($instance) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $number = isset($instance['number']) ? absint($instance['number']) : 5;
        $show_date = isset($instance['show_date']) ? (bool) $instance['show_date'] : false;
        ?>
        <p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'foreverwedding'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo wp_kses_post($title); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts to show:', 'foreverwedding'); ?></label>
            <input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo wp_kses_post($number); ?>" size="3" /></p>

        <p><input class="checkbox" type="checkbox" <?php checked($show_date); ?> id="<?php echo esc_attr($this->get_field_id('show_date')); ?>" name="<?php echo esc_attr($this->get_field_name('show_date')); ?>" />
            <label for="<?php echo esc_attr($this->get_field_id('show_date')); ?>"><?php esc_html_e('Display post date?', 'foreverwedding'); ?></label></p>
        <?php
    }

}
