<?php

/**
 * ForeverWedding -  Categories Widget 
 *  
 * @package foreverwedding
 * @subpackage foreverwedding/inc/widgets
 * @version 1.0.0
 */
class ForeverWedding_instagram extends WP_Widget {

    public function __construct() {
        $widget_ops = array('classname' => 'foreverwedding_widget_instagram', 'description' => esc_html__("Your site&#8217;s Instagram.", 'foreverwedding'));
        parent::__construct('foreverwedding-instagram', esc_html__('Forever Wedding Instagram', 'foreverwedding'), $widget_ops);
        $this->alt_option_name = 'foreverwedding_widget_instagram';
    }

    /**
     * @param array $args
     * @param array $instance
     */
    public function widget($args, $instance) {
        $userid = (!empty($instance['userid']) ) ? $instance['userid'] : "";
        $accesstoken = (!empty($instance['accesstoken']) ) ? $instance['accesstoken'] : "";
        $limit = (!empty($instance['limit']) ) ? $instance['limit'] : 6;
        $title = (!empty($instance['title']) ) ? $instance['title'] : esc_html__('Recent Posts', 'foreverwedding');

        /** This filter is documented in wp-includes/default-widgets.php */
        $title = apply_filters('widget_title', $title, $instance, $this->id_base);
        wp_enqueue_script('business.instafeed');
        echo wp_kses_post($args['before_widget']); 
        if ($title) {
            echo wp_kses_post($args['before_title']) . $title . wp_kses_post($args['after_title']);
        }
        ?>
        <ul id="instafeed"></ul>

        <script type="text/javascript">
            var feed = new Instafeed({
                get: 'user',
                userId: '<?php echo wp_kses_post($userid) ?>',
                accessToken: '<?php echo wp_kses_post($accesstoken) ?>',
                limit: '<?php echo wp_kses_post($limit) ?>',
                resolution: 'thumbnail',
                template: '<li><a href="{{link}}" target="_blank"><img src="{{image}}" width="100" height="100"></a></li>'
            });
            feed.run();
        </script>
        <?php echo wp_kses_post($args['after_widget']);
    }

    /**
     * @param array $new_instance
     * @param array $old_instance
     * @return array
     */
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['userid'] = strip_tags($new_instance['userid']);
        $instance['accesstoken'] = strip_tags($new_instance['accesstoken']);
        $instance['limit'] = strip_tags($new_instance['limit']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['show_date'] = isset($new_instance['show_date']) ? (bool) $new_instance['show_date'] : false;

        return $instance;
    }

    /**
     * @param array $instance
     */
    public function form($instance) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $number = isset($instance['number']) ? absint($instance['number']) : "";
        $userid = isset($instance['userid']) ? absint($instance['userid']) : "";
        $accesstoken = isset($instance['accesstoken']) ? $instance['accesstoken'] : "";
        $limit = isset($instance['limit']) ? $instance['limit'] : 6;
        $show_date = isset($instance['show_date']) ? (bool) $instance['show_date'] : false;
        ?>
        <p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'foreverwedding'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo wp_kses_post($title); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id('userid')); ?>"><?php esc_html_e('userId:', 'foreverwedding'); ?></label>
            <input  class="widefat" id="<?php echo esc_attr($this->get_field_id('userid')); ?>" name="<?php echo esc_attr($this->get_field_name('userid')); ?>" type="text" value="<?php echo wp_kses_post($userid); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id('accesstoken')); ?>"><?php esc_html_e('accesstoken:', 'foreverwedding'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('accesstoken')); ?>" name="<?php echo esc_attr($this->get_field_name('accesstoken')); ?>" type="text" value="<?php echo wp_kses_post($accesstoken); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id('limit')); ?>"><?php esc_html_e('Limit:', 'foreverwedding'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('accesstoken')); ?>" name="<?php echo esc_attr($this->get_field_name('limit')); ?>" type="" value="<?php echo wp_kses_post($limit); ?>" /></p>

        <p><input class="checkbox" type="checkbox" <?php checked($show_date); ?> id="<?php echo esc_attr($this->get_field_id('show_date')); ?>" name="<?php echo esc_attr($this->get_field_name('show_date')); ?>" />
            <label for="<?php echo esc_attr($this->get_field_id('show_date')); ?>"><?php esc_html_e('Display post date?', 'foreverwedding'); ?></label></p>
        <?php
    }

}
