<?php

/**
 * Forever Wedding - Plugin Support
 *  
 * @package foreverwedding
 * @subpackage foreverwedding.inc
 * @since foreverwedding 1.0.0
 */

/**
 * Forever Wedding - Visual composer
 * @since foreverwedding 1.0.0 
 */
add_action( 'vc_before_init', 'foreverwedding_vc_set_as_theme' );
function foreverwedding_vc_set_as_theme() {
   vc_set_as_theme();
}

//redirect welcome stop
delete_transient( '_vc_page_welcome_redirect' );


/**
 * Forever Wedding - RevoSlider
 * @since foreverwedding 1.0.0 
 */
add_action('admin_init', 'foreverwedding_disable_revslider_notice');

/* Disable revslider notice */
function foreverwedding_disable_revslider_notice() {
    if( get_option('revslider-valid', 'false') == 'false' ||  get_option('revslider-valid-notice', 'true') == 'true') {
        update_option('revslider-valid', 'true');
        update_option('revslider-valid-notice', 'false');
    }
}

//Hide mailchimp admin notice
update_option("mc4wp_usage_tracking_nag_shown", "1");
