<?php

/**
 * Forever Wedding - General
 *
 * @package foreverwedding
 * @subpackage foreverwedding.inc.options.field
 * @since foreverwedding 1.0
 */
return array(
    array(
        'id' => 'foreverwedding_logo',
        'label' => esc_html__('Site Header Logo', 'foreverwedding'),
        'desc' => esc_html__('Upload Site header Logo Here', 'foreverwedding'),
        'std' => '',
        'type' => 'upload',
        'section' => 'foreverwedding_general_section',
        'rows' => '',
        'post_type' => '',
        'taxonomy' => '',
        'min_max_step' => '',
        'class' => '',
        'condition' => '',
        'operator' => 'and'
    ),
    array(
        'id' => 'foreverwedding_stickey_header',
        'label' => esc_html__('Header Types', 'foreverwedding'),
        'desc' => esc_html__('Select Header Types', 'foreverwedding'),
        'std' => '',
        'type' => 'select',
        'section' => 'foreverwedding_general_section',
        'rows' => '',
        'post_type' => '',
        'taxonomy' => '',
        'min_max_step' => '',
        'class' => '',
        'condition' => '',
        'operator' => 'and',
        'choices' => array(
            array(
                'value' => 'normal',
                'label' => esc_html__('Normal', 'foreverwedding'),
                'src' => ''
            ),
            array(
                'value' => 'fix',
                'label' => esc_html__('Fixed', 'foreverwedding'),
                'src' => ''
            ),
            array(
                'value' => 'intelligent',
                'label' => esc_html__('Intelligent', 'foreverwedding'),
                'src' => ''
            )
        )
    ),
    array(
        'id' => 'foreverwedding_theme_layout',
        'label' => esc_html__('Theme Layout', 'foreverwedding'),
        'desc' => esc_html__('Select Theme Layout', 'foreverwedding'),
        'std' => '',
        'type' => 'select',
        'section' => 'foreverwedding_general_section',
        'rows' => '',
        'post_type' => '',
        'taxonomy' => '',
        'min_max_step' => '',
        'class' => '',
        'condition' => '',
        'operator' => 'and',
        'choices' => array(
            array(
                'value' => 'fullWidth',
                'label' => esc_html__('Full Width', 'foreverwedding'),
                'src' => ''
            ),
            array(
                'value' => 'boxed',
                'label' => esc_html__('Boxed', 'foreverwedding'),
                'src' => ''
            )
        )
    ),
    array(
        'id' => 'banner_on_off',
        'label' => esc_html__('Blog Banner On/Off', 'foreverwedding'),
        'desc' => '',
        'std' => '',
        'type' => 'on-off',
        'section' => 'foreverwedding_general_section',
        'rows' => '',
        'post_type' => '',
        'taxonomy' => '',
        'min_max_step' => '',
        'class' => '',
        'condition' => '',
        'operator' => 'and'
    ),
    array(
        'id' => 'foreverwedding_banner_image',
        'label' => esc_html__('Upload Global Banner Image', 'foreverwedding'),
        'desc' => esc_html__('Upload Global a banner.', 'foreverwedding'),
        'std' => '',
        'type' => 'upload',
        'section' => 'foreverwedding_general_section',
        'condition' => 'banner_on_off:not(off)',
        'operator' => 'and',
        'choices' => ''
    ),
    array(
        'id' => 'page_comment_on_off',
        'label' => esc_html__('Page Comment On/Off', 'foreverwedding'),
        'desc' => '',
        'std' => '',
        'type' => 'on-off',
        'section' => 'foreverwedding_general_section',
        'rows' => '',
        'post_type' => '',
        'taxonomy' => '',
        'min_max_step' => '',
        'class' => '',
        'condition' => '',
        'operator' => 'and'
    ),
    array(
        'id' => 'comment_form_title',
        'label' => esc_html__('Comment Form Title', 'foreverwedding'),
        'desc' => esc_html__('Comment Form Title.', 'foreverwedding'),
        'std' => '',
        'type' => 'text',
        'section' => 'foreverwedding_general_section',
        'condition' => 'page_comment_on_off:not(off)',
        'operator' => 'and'
    ),
    array(
        'id' => 'comment_form_sub_title',
        'label' => esc_html__('Comment Form Sub Title', 'foreverwedding'),
        'desc' => esc_html__('Comment Form Sub Title.', 'foreverwedding'),
        'std' => '',
        'type' => 'text',
        'section' => 'foreverwedding_general_section',
        'condition' => 'page_comment_on_off:not(off)',
        'operator' => 'and'
    ),
);
