<?php

/**
 * ForeverWedding - Helper Function
 * It has theme setup functionality
 *
 * @package foreverwedding
 * @subpackage foreverwedding/inc
 * @version 1.0.0
 */
function foreverwedding_active_site($return_type = true) {
    if ($return_type):
	return (ot_get_option('foreverwedding_site') == 'site1') ? true : false;
    else:
	return (ot_get_option('foreverwedding_site') != '') ? ot_get_option('foreverwedding_site') : 'site1';
    endif;
}

function foreverwedding_move_comment_field_to_bottom($fields) {
    $comment_field = $fields['comment'];
    unset($fields['comment']);
    $fields['comment'] = $comment_field;
    return $fields;
}

add_filter('comment_form_fields', 'foreverwedding_move_comment_field_to_bottom');

function foreverwedding_my_search_form($form) {
    $form = '<form role="search" method="get" id="searchform" class="searchform" action="' . home_url('/') . '" >
	<div class="search-box"><label class="screen-reader-text" for="s">' . esc_html__('Search for:', 'foreverwedding') . '</label>
	<input type="text" value="' . get_search_query() . '" name="s" id="search-blog" placeholder="Search..." required/>
	<i class="fa fa-search"> </i>
	</div>
	</form>';

    return $form;
}

add_filter('get_search_form', 'foreverwedding_my_search_form');

function foreverwedding_mime_types($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}

add_filter('upload_mimes', 'foreverwedding_mime_types');
add_filter('mime_types', 'foreverwedding_mime_types');

/**
 * Google Font Families
 * 
 * @return array
 */
function foreverwedding_google_font_families() {
    $fonts = array();

    $ot_fonts = ot_get_option('foreverwedding_google_fonts');
    $ot_google_font_list = ot_recognized_google_font_families('foreverwedding_google_fonts');
    if (!empty($ot_fonts) && count($ot_fonts) > 0) {
	foreach ($ot_fonts as $ot_font) {
	    if (!empty($ot_font['family']) && !empty($ot_google_font_list[$ot_font['family']])) {
		$fonts[] = array(
		    'value' => $ot_google_font_list[$ot_font['family']],
		    'label' => $ot_google_font_list[$ot_font['family']],
		    'src' => ''
		);
	    }
	}
    }

    return $fonts;
}




