<?php
/**
 * ForeverWedding - General Layout 
 * 
 * This page has layout functionality
 *  
 * @package foreverwedding
 * @subpackage foreverwedding/inc
 * @version 1.0.0
 */

/**
 * Forever Wedding  - action: foreverwedding_header
 * @since foreverwedding 1.0.0
 */
function foreverwedding_get_header() {
    $part = "content/header/header";
    $layout = foreverwedding_active_site(false);
    switch ($layout) {
        case "site2":
            get_template_part($part, 'two');
            break;
        default:
            get_template_part($part, 'one');
            break;
    }
}

add_action('foreverwedding_header', 'foreverwedding_get_header');

/**
 * Forever Wedding  - action: foreverwedding_footer
 * @since foreverwedding 1.0.0
 */
function foreverwedding_get_footer() {
    $layout = foreverwedding_active_site(false);
    $part = "content/footer/footer";
    switch ($layout) {
        case "site2":
            get_template_part($part, 'two');
            break;
        default:
            get_template_part($part, 'one');
            break;
    }
}

add_action('foreverwedding_footer', 'foreverwedding_get_footer');

/**
 * Forever Wedding  - action: foreverwedding_nav_menu
 * @since foreverwedding 1.0.0
 */
function foreverwedding_nav_menu() {
    $locations = get_theme_mod('nav_menu_locations');
    if (empty($locations)) {
        echo '<nav class="tr_customize_view">';
        wp_nav_menu(array(
            'container' => 'ul',
            'container_id' => 'cssmenu',
            'menu_class' => 'navigation clearfix',
        ));
        echo '</nav>';
    } else {
        if (isset($locations['primary_navigation'])) {
            if ($locations['primary_navigation'] == 0) :
                wp_nav_menu(array(
                    'container' => 'ul',
                    'container_id' => 'cssmenu',
                    'menu_class' => 'navigation clearfix',
                ));
            else:
                wp_nav_menu(array(
                    'theme_location' => 'primary_navigation',
                    'container' => 'nav',
                    'container_id' => 'cssmenu',
                    'menu_class' => 'navigation clearfix',
                ));
            endif;
        }
    }
}

add_action('foreverwedding_nav_menu', 'foreverwedding_nav_menu');

/**
 * Forever Wedding - site loader
 * @since foreverwedding 1.0.0
 */
function foreverwedding_site_loader() {
    if (ot_get_option('foreverwedding_site_loader') == 'on'):
        ?>
        <div id="loading">
		    <div id="loading-center">
			    <div id="loading-center-absolute">
				    <div class="object" id="object_four"></div>
				    <div class="object" id="object_three"></div>
				    <div class="object" id="object_two"></div>
				    <div class="object" id="object_one"></div>
			    </div>
		    </div>
	    </div>

        <?php
    endif;
}

add_action("wp_footer", "foreverwedding_site_loader");

/**
 * Forever Wedding - Comming Soon layout ( Site )
 * @since foreverwedding 1.0.0
 */
function foreverwedding_comingsoon_redirect() {
    $coming_soon_option = ot_get_option('foreverwedding_coming_soon_mod');
    if ($coming_soon_option == 'on' && !is_user_logged_in()) {
	require_once trailingslashit( get_template_directory() ).'/content/coming-soon-display.php';
	die();
    }
}

add_action('template_redirect', 'foreverwedding_comingsoon_redirect');


/**
 * Foreverwedding - single href link
 * @since foreverwedding 1.0.0
 */
function foreverwedding_set_single_nav_link($atts, $item, $args, $depth){
	if('on' == ot_get_option('foreverwedding_single_page_mode')){
		if($depth == 0):
		 if(!is_front_page()):
		   $atts['href'] = home_url('/').'#'.sanitize_title($item->title);
		 else:
		$atts['href'] = '#'.sanitize_title($item->title);
		endif;
		
		endif;
	}
	return $atts;
}
add_filter('nav_menu_link_attributes', 'foreverwedding_set_single_nav_link', 10, 4);
