<?php
/**
 * ForeverWedding - Blog Layout 
 * 
 * This page has layout functionality
 *  
 * @package foreverwedding
 * @subpackage foreverwedding/inc
 * @version 1.0.0
 */

/**
 * Forever Wedding  - action: foreverwedding_post_share
 * @since foreverwedding 1.0.0
 */
function foreverwedding_post_share() {
    $on_off = 'on';//ot_get_option('social_share_on_off');
    if ('on' != $on_off || empty($on_off)) {
        return;
    }
    ?>
   <div class="inner-footer-wrapper clearfix">
    	 <ul class="blog-sidebar-social-icon-list share-block clearfix">
    	    <li>
    	        <span><?php echo esc_html_e('Share:', 'foreverwedding'); ?></span>
    	    </li>
    	    <?php
    	    $social_share = ot_get_option('foreverwedding_social_share');
    	    if (!empty($social_share) && is_array($social_share)):
    	        foreach ($social_share as $social):
    	            ?>
    	            <li>
    	                <a href="<?php echo esc_url(do_shortcode($social['link'])); ?>" target="_blank" title="<?php echo esc_attr($social['title']); ?>" class="fb-wrapper"><i class="fa <?php echo esc_attr($social['class']); ?>"></i></a>
    	            </li>
    	            <?php
    	        endforeach;
    	    endif;
    	    ?>
    	</ul>
    	<div class="clearfix"><ul class="pager"><?php previous_post_link('<li class="next">%link</li>', 'next'); ?><?php next_post_link('<li class="previous">%link</li>', 'prev'); ?> </ul></div>
    </div>
    <?php
}

add_action('foreverwedding_post_share', 'foreverwedding_post_share');

/**
 * Forever Wedding  - action: the_content_more_link
 * @since foreverwedding 1.0.0
 */
function foreverwedding_the_content_more_link() {
    return '';
}

add_filter('the_content_more_link', 'foreverwedding_the_content_more_link');
add_filter('excerpt_more', 'foreverwedding_the_content_more_link');

function foreverwedding_customize_register( $wp_customize ) {
    add_filter("body_class", "foreverwedding_customizer_view_body");
    
}
add_action('customize_register', 'foreverwedding_customize_register');

function foreverwedding_customizer_view_body($class) {
    $theme = wp_get_theme(); // gets the current theme
    if ('foreverwedding' != $theme->name) {
        $class[] = 'foreverwedding-not-active';
    }
    $class[] = 'foreverwedding-customize-view ';
    return $class;
}

function foreverwedding_blog_banner($title) {
    $on_off = ot_get_option('banner_on_off');
    if ('on' != $on_off || empty($on_off)) {
        return;
    }
    $url = ot_get_option('foreverwedding_banner_image');
    if (!empty($url)):
        ?>
        <div class="parallax-window" data-parallax="scroll" data-image-src="<?php echo esc_url($url); ?>">
				<section class="banner">
					<div class="banner-content-wrapper">
						<h1><?php echo esc_html($title); ?> </h1>
					</div>
				</section>
			</div>
        <?php
    endif;
}

add_action('foreverwedding_blog_banner', 'foreverwedding_blog_banner');

function foreverwedding_get_blog_layout() {
    $layout = foreverwedding_active_site(false);;
    $part = "content/blog/blog";
    switch ($layout) {
        case "site2":
            get_template_part($part, 'two');
            break;
        default:
            get_template_part($part, 'one');
            break;
    }
}

add_action('foreverwedding_blog_layout', 'foreverwedding_get_blog_layout');

function foreverwedding_get_single_layout() {
    $layout = foreverwedding_active_site(false);
    $part = "content/single/single";
    switch ($layout) {
        case "site2":
            get_template_part($part, 'two');
            break;
        default:
            get_template_part($part, 'one');
            break;
    }
}

add_action('foreverwedding_single_layout', 'foreverwedding_get_single_layout');


function foreverwedding_body_class($classes) {
    global $is_lynx, $is_gecko, $is_IE, $is_opera, $is_NS4, $is_safari, $is_chrome, $is_iphone;
    $browser_version = array();
    if ($is_lynx)
	$classes[] = 'lynx';
    elseif ($is_gecko)
	$classes[] = 'gecko';
    elseif ($is_opera)
	$classes[] = 'opera';
    elseif ($is_NS4)
	$classes[] = 'ns4';
    elseif ($is_safari)
	$classes[] = 'safari';
    elseif ($is_chrome)
	$classes[] = 'chrome';
    elseif ($is_IE) {
	$classes[] = 'ie';
	if (preg_match('/MSIE ([0-9]+)([a-zA-Z0-9.]+)/', $_SERVER['HTTP_USER_AGENT'], $browser_version))
	    $classes[] = 'ie' . $browser_version[1];
    } else
	$classes[] = 'unknown';
    if ($is_iphone)
	$classes[] = 'iphone';
    if (stristr($_SERVER['HTTP_USER_AGENT'], "mac")) {
	$classes[] = 'osx';
    } elseif (stristr($_SERVER['HTTP_USER_AGENT'], "linux")) {
	$classes[] = 'linux';
    } elseif (stristr($_SERVER['HTTP_USER_AGENT'], "windows")) {
	$classes[] = 'windows';
    }

    return $classes;
}

add_filter('body_class', 'foreverwedding_body_class');



function foreverwedding_category_filter($post_id) {
       $project_terms = get_the_terms($post_id, 'category');
    $args = array();

    if (is_array($project_terms)):
		  $args[] = '<i class="fa fa-folder-open-o"></i> ';
        foreach ($project_terms as $project_term):
            $term_link = get_term_link( $project_term );
            $args[] .= '<a href="'.$term_link.'"><span> '.$project_term->slug.' </span></a>';
			
        endforeach;
    endif;

    return implode("", $args);
}
add_filter('foreverwedding_category_filter', 'foreverwedding_category_filter');
