<?php
/**
 * Forever Wedding - Theme Assets
 * It has theme assets functionality
 *  
 * @package foreverwedding
 * @subpackage foreverwedding/inc
 * @version 1.0.0
 */

/**
 * Forever Wedding - eneque scripts
 * 
 * @since foreverwedding 1.0.0
 */
function foreverwedding_enqueue_script_style() {
    global $wp_scripts;
    
    wp_enqueue_style('font-awesome', FOREVERWEDDING_THEME_URL . '/assets/css/font-awesome.min.css', array(), null, 'all');
    wp_enqueue_style('simple-line-icons', FOREVERWEDDING_THEME_URL . '/assets/css/simple-line-icons.css', array(), null, 'all');
    wp_enqueue_style('bootstrap', FOREVERWEDDING_THEME_URL . '/assets/css/bootstrap.css', array(), null, 'all');
    wp_enqueue_style('foreverwedding.layers', FOREVERWEDDING_THEME_URL . '/assets/css/layers.css', array(), null, 'all');
    wp_enqueue_style('audioplayer', FOREVERWEDDING_THEME_URL . '/assets/css/audioplayer.css', array(), null, 'all');
    wp_enqueue_style('owl.carousel', FOREVERWEDDING_THEME_URL . '/assets/css/owl.carousel.css', array(), null, 'all');
    wp_enqueue_style('jquery-fancybox', FOREVERWEDDING_THEME_URL . '/assets/css/jquery.fancybox.css', array(), null, 'all');
    wp_enqueue_style('foreverwedding.global', FOREVERWEDDING_THEME_URL . '/assets/css/global.css', array(), null, 'all');
    
    wp_enqueue_style('foreverwedding.site', FOREVERWEDDING_THEME_URL . '/assets/css/forever-wedding-style.css', array(), null, 'all');
    $foreverwedding_custom_css = ot_get_option('foreverwedding_custom_css');
    wp_add_inline_style('foreverwedding.site', $foreverwedding_custom_css);

    
    wp_enqueue_style('foreverwedding.responsive', FOREVERWEDDING_THEME_URL . '/assets/css/responsive.css', array(), null, 'all');
    wp_enqueue_style('foreverwedding.skin', FOREVERWEDDING_THEME_URL . '/assets/css/skin.less', array(), null, 'all');
    wp_enqueue_style('foreverwedding.wp-integration', FOREVERWEDDING_THEME_URL . '/assets/css/wp-integration.css', array(), null, 'all');
    wp_enqueue_style('foreverwedding.wordpress.responsive', FOREVERWEDDING_THEME_URL . '/assets/css/wordpress-responsive.css', array(), null, 'all');
    wp_enqueue_style('foreverwedding.style', get_stylesheet_uri(), array(), null, 'all');
    
    
    
    $googleapisArgs = array('sensor' => false);
    $foreverwedding_google_map_api_key = ot_get_option('foreverwedding_google_map_api_key');
    if(!empty($foreverwedding_google_map_api_key)) {
	$googleapisArgs['key'] = $foreverwedding_google_map_api_key;
    }
    wp_register_script('foreverwedding-googleapis', add_query_arg($googleapisArgs, '//maps.googleapis.com/maps/api/js'), array('jquery'), null, true);
    
    wp_register_script('foreverwedding-particle', FOREVERWEDDING_THEME_URL . '/assets/js/particles.min.js', array('jquery'), null, true);
    wp_register_script('foreverwedding-particle-app', FOREVERWEDDING_THEME_URL . '/assets/js/particles_app.js', array('jquery'), null, true);


    wp_enqueue_script( 'html5shiv',  FOREVERWEDDING_THEME_URL.'/assets/js/html5shiv.min.js',  array(), null, true);
    $wp_scripts->add_data( 'html5shiv', 'conditional', 'lt IE 9' );

    wp_enqueue_script('bootstrap', FOREVERWEDDING_THEME_URL . '/assets/js/bootstrap.js', array('jquery'), null, true);
    wp_enqueue_script('less', FOREVERWEDDING_THEME_URL . '/assets/js/less.js', array('jquery'), null, true);
    wp_enqueue_script('owl-carousel', FOREVERWEDDING_THEME_URL . '/assets/js/owl.carousel.js', array('jquery'), null, true);
    wp_enqueue_script('parallax', FOREVERWEDDING_THEME_URL . '/assets/js/parallax.js', array('jquery'), null, true);
    wp_enqueue_script('jquery-appear', FOREVERWEDDING_THEME_URL . '/assets/js/jquery.appear.js', array('jquery'), null, true);
    wp_enqueue_script('isotope-pkgd', FOREVERWEDDING_THEME_URL . '/assets/js/isotope.pkgd.js', array('jquery'), null, true);
    wp_enqueue_script('jquery-fancybox', FOREVERWEDDING_THEME_URL . '/assets/js/jquery.fancybox.js', array('jquery'), null, true);
    wp_enqueue_script('jquery-countTo', FOREVERWEDDING_THEME_URL . '/assets/js/jquery.countTo.js', array('jquery'), null, true);
    wp_enqueue_script('jquery-plugin', FOREVERWEDDING_THEME_URL . '/assets/js/jquery.plugin.js', array('jquery'), null, true);
    wp_enqueue_script('jquery-countdown', FOREVERWEDDING_THEME_URL . '/assets/js/jquery.countdown.js', array('jquery'), null, true);
    wp_enqueue_script('audioplayer', FOREVERWEDDING_THEME_URL . '/assets/js/audioplayer.js', array('jquery'), null, true);
    
    //foreverwedding.site
    wp_enqueue_script('foreverwedding.site', FOREVERWEDDING_THEME_URL . '/assets/js/site.js', array('jquery', 'foreverwedding-googleapis'), null, true);
    $single_page_mod = ('on' != ot_get_option('foreverwedding_single_page_mode')) ? 'off' : 'on';
    $site_options = array(
	'lat' => ot_get_option('foreverwedding_latitude'),
	'lng' => ot_get_option('foreverwedding_longitude'),
	'icourl' => FOREVERWEDDING_THEME_URL . '/assets/images/map-icon-2.png',
	'date' => ot_get_option('coming_soon_date'),
	'month' => ot_get_option('coming_soon_month'),
	'year' => ot_get_option('coming_soon_year'),
	'projets' => ot_get_option('foreverwedding_projects_done'),
	'awards' => ot_get_option('foreverwedding_awards_won'),
	'montre' => ot_get_option('foreverwedding_montre_springta'),
	'hours' => ot_get_option('foreverwedding_happy_hours'),
	'site_mod' => $single_page_mod,
	'site_url' => home_url('/'),
    );
    wp_localize_script('foreverwedding.site', 'FOREVERWEDDING_SITE_OPTION', $site_options);
    
    //custom load
    wp_enqueue_script('foreverwedding.custom-load', FOREVERWEDDING_THEME_URL . '/assets/js/ajax-load.js', array('jquery'), null, true);
    wp_localize_script('foreverwedding.custom-load', 'FOREVERWEDDING_CUSTOM_LOAD', array('ajaxurl' => admin_url('admin-ajax.php')));
    wp_enqueue_script('foreverwedding.instafeed', FOREVERWEDDING_THEME_URL . '/assets/js/instafeed.min.js', array('jquery'), null, false);
    wp_enqueue_script('foreverwedding.rotator', FOREVERWEDDING_THEME_URL . '/assets/js/jquery.simple-text-rotator.min.js', array('jquery'), null, true);

    //theme options
    wp_enqueue_script('foreverwedding.options', FOREVERWEDDING_THEME_URL . '/assets/theme-option/options.js', array('jquery'), null, true);
    $theme_options = array(
	'url' => FOREVERWEDDING_THEME_URL,
	'color' => (ot_get_option('foreverwedding_color_main') != "") ? ot_get_option('foreverwedding_color_main') : "#50b9ce", //
	'font' => (ot_get_option('foreverwedding_theme_font') != "") ? ot_get_option('foreverwedding_theme_font') : "Open Sans", //
	'heading_font' => (ot_get_option('foreverwedding_headings_font') != "") ? ot_get_option('foreverwedding_headings_font') : "Raleway", //
	'sub_heading_font' => (ot_get_option('foreverwedding_sub_headings_font') != "") ? ot_get_option('foreverwedding_sub_headings_font') : "Lora", //
	'header' => (ot_get_option('foreverwedding_stickey_header') != "") ? ot_get_option('foreverwedding_stickey_header') : "normal", //
	'layout' => (ot_get_option('foreverwedding_theme_layout') != "") ? ot_get_option('foreverwedding_theme_layout') : "fullWidth", //
    );
    wp_localize_script('foreverwedding.options', 'FOREVERWEDDING_OPTION', $theme_options);

    if (is_singular()) {
	wp_enqueue_script("comment-reply");
    }
    
    
}
add_action('wp_enqueue_scripts', 'foreverwedding_enqueue_script_style');


/**
 * Forever Wedding - skin less & html5shiv
 * 
 * @since foreverwedding 1.0.0
 * 
 */
function foreverwedding_less() {
  // echo '<link href="'.esc_url(FOREVERWEDDING_THEME_URL . '/assets/css/skin.less').'" rel="stylesheet/less" />';
}
add_action('wp_head', 'foreverwedding_less');

/**
 * Forever Wedding -  Admin enqueue script
 * @since foreverwedding 1.0.0
 */
function foreverwedding_admin_assets() {
    wp_enqueue_style('foreverwedding.ot.ui', FOREVERWEDDING_THEME_URL . '/assets/admin/option-tree-ui.css', array(), null, 'all');
    wp_enqueue_script('foreverwedding.f-admin', FOREVERWEDDING_THEME_URL . '/assets/admin/f-admin.js', array('jquery'), null, 'all');
} 
add_action('admin_enqueue_scripts', 'foreverwedding_admin_assets', 100);
