<?php
/**
 * Template Name: Single Page Layout Template
 * 
 * This is Visual composer page template layout
 * 
 * @package foreverwedding
 * @subpackage foreverwedding
 * @since foreverwedding 1.0.0
 * 
 */
get_header();
?>
<!--Content Area Start-->
<div id="content">
    <?php
    $theme_locations = get_nav_menu_locations();
    if (isset($theme_locations['primary_navigation'])):
	$menu_obj = get_term($theme_locations['primary_navigation'], 'nav_menu');
	if (isset($menu_obj->term_id)):
	    $menuItems = wp_get_nav_menu_items($menu_obj->term_id);
	    if (count($menuItems) > 0):
		foreach ($menuItems as $menuItem):
		    if ($menuItem->menu_item_parent == 0) :
			$menu_section_post = get_post($menuItem->object_id);
			if (!empty($menu_section_post->post_content)) :
			    ?>
			    <div class="single-section-container" data-id="<?php echo esc_attr($menu_section_post->ID); ?>" id="<?php echo $menu_section_post->post_name; ?>">
				<?php echo apply_filters('the_content', $menu_section_post->post_content); ?>
			    </div>
			    <?php
			endif;
		    endif;
		endforeach;
	    endif;
	endif;
    endif;

    echo ob_get_clean();
    ?>
</div>
<?php
get_footer();
