<?php
/**
 * Forever Wedding - standard format
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.content.format
 * @since foreverwedding 1.0.0
 */
?>
<?php
global $foreverwedding_single;

if ($foreverwedding_single == 'single'):
    ?>
    <div <?php post_class('row'); ?>>
        <article class="blog-post-wrapper padding">
            <?php if (is_sticky()): ?>
                <span class="stick-pin"><i class="fa fa-thumb-tack"></i></span>
                <?php
            endif;
          
            $foreverwedding_url = wp_get_attachment_url(get_post_thumbnail_id());
            if (!empty($foreverwedding_url)):
                if (!is_search()):
                    ?>
                    <figure>  
                        <img src="<?php echo apply_filters('foreverwedding_image_resize', $foreverwedding_url, '870', '408'); ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>">
                    </figure>
                    <?php
                endif;
            endif;
            ?>
            <div class="post-blog blog-single-quotes">
                <?php if (!is_page() && ! is_search()): ?>	
                    <?php $foreverwedding_category = get_the_category(); ?>				
                    <span class="timing-blog"><a href="<?php echo get_month_link(get_the_time('Y'), get_the_time('m')); ?>"><i class="fa fa-calendar"> </i> <span><?php echo get_the_date('F d , Y'); ?></span></a> 
                        <?php echo apply_filters('foreverwedding_category_filter', get_the_ID()); ?></span>
                    <?php
                endif;
                $foreverwedding_flag = false;
                if ($foreverwedding_flag) {
                    the_tags('<ul><li>', '</li><li>', '</li></ul>');
                }
                ?>
                <h2> <a href="<?php the_permalink(); ?>"><?php $foreverwedding_post_title=get_the_title(); (!empty($foreverwedding_post_title) ? the_title() : esc_html_e('untitled','foreverwedding'));?></a></h2>
                <?php
                if (is_search()):
                    $foreverwedding_view = apply_filters('the_content', get_the_excerpt());
                    echo (!empty($foreverwedding_view)) ? wp_kses_post($foreverwedding_view, 'foreverwedding') : wp_kses_post('<p>Visual Composer Page</p>', 'foreverwedding');
                else:
                    the_content();
                   $post_content = get_post_field('post_content', get_the_ID());
		    if (1 < strpos($post_content, '<!--more-->') && !is_single()) {
			?>
	    	    <a href="<?php the_permalink(); ?>" class="btn btn-default"><?php echo esc_html_e('read more', 'foreverwedding'); ?> <i class="fa fa-angle-right"></i></a>
		    <?php } ?>
		    <?php wp_link_pages(); 
                endif;
                ?>
                <?php do_action('foreverwedding_post_share'); ?>           
            </div>
        </article>
    </div>
<?php else: ?>
    <div <?php post_class('row'); ?>>
        <article class="blog-post-wrapper ">
            <?php if (is_sticky()): ?>
                <span class="stick-pin"><i class="fa fa-thumb-tack"></i></span>
                <?php
            endif;
            ?>
            <?php
            $foreverwedding_url = wp_get_attachment_url(get_post_thumbnail_id());
            if (!empty($foreverwedding_url)):
                if (!is_search()):
                    ?>
                    <figure>  
		               <?php $layout = foreverwedding_active_site(false);
						if($layout == 'site2') { ?>
							 <img src="<?php echo apply_filters('foreverwedding_image_resize', $foreverwedding_url, '870', '408'); ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>">	
						<?php }
						else { ?>
							<img src="<?php echo esc_attr($foreverwedding_url); ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>">		
						<?php } ?>               
                    </figure>
                    <?php
                endif;
            endif;
            ?>
            <div class="post-blog">
                <?php 
		if(!is_search()):
		$foreverwedding_category = get_the_category(); ?>					
                <span class="timing-blog"><a href="<?php echo get_month_link(get_the_time('Y'), get_the_time('m')); ?>"><i class="fa fa-calendar"> </i> <span><?php echo get_the_date('F d , Y'); ?></span></a>  
                    <?php echo apply_filters('foreverwedding_category_filter', get_the_ID()); ?></span>
                <?php
		endif;
                $foreverwedding_thmb = false;
                if ($foreverwedding_thmb): the_post_thumbnail();
                endif; ?>
                <h2> <a href="<?php the_permalink(); ?>"><?php $foreverwedding_post_title=get_the_title(); (!empty($foreverwedding_post_title) ? the_title() : esc_html_e('untitled','foreverwedding'));?></a></h2>
                <?php	
                if (is_search()):
                    $foreverwedding_view = apply_filters('the_content', get_the_excerpt());
                    echo (!empty($foreverwedding_view)) ? wp_kses_post($foreverwedding_view, 'foreverwedding') : wp_kses_post('<p>Visual Composer Page</p>', 'foreverwedding');
                else:
                    the_content();
                    $post_content = get_post_field('post_content', get_the_ID());
		    if (1 < strpos($post_content, '<!--more-->') && !is_single()) {
			?>
	    	    <a href="<?php the_permalink(); ?>" class="btn btn-default"><?php echo esc_html_e('read more', 'foreverwedding'); ?> <i class="fa fa-angle-right"></i></a>
		    <?php } ?>
		    <?php wp_link_pages(); 
                endif;
                if (!is_single() && !is_search()) : ?>
                <div class="foreverwedding-tags">
					<?php $foreverwedding_flag = true;
	                if ($foreverwedding_flag) {
	                    the_tags('TAGS: ', ' ', '');
	                }
	                ?>
                </div>
                <?php endif; ?>
            </div>
        </article>
    </div>
<?php endif; 
