<?php
/**
 * ForeverWedding - This page is displaying footer two teplate
 * 
 * @package foreverwedding
 * @subpackage foreverwedding/content/footer
 * @version 1.0.0
 */
?>
<!--Footer Section Start-->
<footer id="footer" class="footer-two home-agency">
    <div class="primary-footer">
        <div class="container">
            <div class="row">
                <div class="col-xs-12">
                    <div class="footer-logo">
                        <?php
                        $foreverwedding_footer_logo = ot_get_option('foreverwedding_footer_logo');
                        $foreverwedding_footer_logo = (!empty($foreverwedding_footer_logo)) ? $foreverwedding_footer_logo : FOREVERWEDDING_THEME_URL . '/assets/images/logo-footer.png';
                        ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($foreverwedding_footer_logo); ?>"  alt="<?php echo get_bloginfo('name'); ?>" title="<?php echo get_bloginfo('name'); ?>"  /></a>
                        <div class="sec-block">

                            <?php
                            $foreverwedding_address_label_text = ot_get_option('address_label_text');
                            $foreverwedding_address = ot_get_option('foreverwedding_address');
                            if (!empty($foreverwedding_address)):
                                ?>                       
                                <h5><?php echo ($foreverwedding_address_label_text) ? $foreverwedding_address_label_text : esc_html__('Forever Wedding', 'foreverwedding'); ?></h5>  <address><?php echo wp_kses_post($foreverwedding_address); ?></address>                         
                            <?php endif; ?>							
                        </div>
                        <div class="sec-block sec-block-right">
                            <?php
                            $foreverwedding_email_label_text = ot_get_option('email_label_text');
                            $foreverwedding_email = ot_get_option('foreverwedding_email');
                            if (!empty($foreverwedding_email)):
                                ?>                       
                                <span class="email-info"><?php echo ($foreverwedding_email_label_text) ? $foreverwedding_email_label_text : esc_html__('Email ', 'foreverwedding'); ?> <a class="mail" href="mailto:<?php echo esc_attr(trim($foreverwedding_email)); ?>">  <?php echo esc_html($foreverwedding_email); ?></a></span>                         
                            <?php endif; 
                            $foreverwedding_phone_no = ot_get_option('phone_no'); 
                            if (!empty($foreverwedding_phone_no)): 
								
                                $foreverwedding_phone_no_label = ot_get_option('phone_no_label'); ?>                       
                                <span class="email-info"><?php echo (!empty($foreverwedding_phone_no_label)) ? wp_kses($foreverwedding_phone_no_label, wp_kses_allowed_html('post')) : esc_html__('Phone ', 'foreverwedding'); ?> 
                                	<a class="call" href="tel:<?php echo preg_replace('/[^0-9]/', '', $foreverwedding_phone_no); ?>"> <?php echo esc_html($foreverwedding_phone_no); ?> </a> </span>                         
                            <?php endif; ?>
                            <div class="right-footer">
                                <?php
                                $foreverwedding_social_icons = ot_get_option('foreverwedding_social_icons');
                                if (is_array($foreverwedding_social_icons) && !empty($foreverwedding_social_icons)):
                                    ?>
                                    <ul class="menu clearfix">
                                        <?php foreach ($foreverwedding_social_icons as $social):
                                            ?>
                                            <li>
                                                <a class="circle-class" target="_blank" href="<?php echo esc_url($social['link']); ?>" title="<?php echo esc_attr($social['title']); ?>"> <i class="fa <?php echo esc_attr($social['class']); ?>"></i> </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="main-footer">
        <div class="container">
            <div class="row">
                <div class="left-footer">
                    <?php
                    $foreverwedding_copy = ot_get_option('foreverwedding_copyright');
                    if (!empty($foreverwedding_copy)):
                        ?>
                        <span class="psd-temp-class"><?php echo wp_kses_post($foreverwedding_copy); ?></span>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
</footer>
<!--Footer Section End-->
<?php 