<?php
/**
 * Forever Wedding - Comment layout
 * 
 * @package foreverwedding
 * @since foreverwedding 1.0.0
 */
if (post_password_required()) {
    return;
}
?>
<div id="comments" class="comments-area">
    <?php if (have_comments()) : ?>
        <h2 class="comments-title comment-title-heading">
            <?php
            printf(_nx('One Comments on &ldquo;%2$s&rdquo;', '%1$s Comments', get_comments_number(), 'comments title', 'foreverwedding'), number_format_i18n(get_comments_number()), get_the_title());
            ?>
        </h2>
        <ul class="commentlist user-comment-list">
            <?php wp_list_comments(array('callback' => 'foreverwedding_comment', 'style' => 'ul')); ?>
        </ul><!-- .commentlist -->
        <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : // are there comments to navigate through    ?>
            <nav id="comment-nav-below" class="navigation" role="navigation">
                <p><span class="nav-previous"><?php previous_comments_link(esc_html__('&larr; Older Comments', 'foreverwedding')); ?></span>
                    &nbsp;&nbsp;
                    <span class="nav-next"><?php next_comments_link(esc_html__('Newer Comments &rarr;', 'foreverwedding')); ?></span></p>
            </nav>
        <?php endif; // check for comment navigation    ?>
        <?php
        /* If there are no comments and comments are closed, let's leave a note.
         * But we only want the note on posts and pages that had comments in the first place.
         */
        if (!comments_open() && get_comments_number()) :
            ?>
            <p class="nocomments"><?php esc_html_e('Comments are closed.', 'foreverwedding'); ?></p>
        <?php endif; ?>

        <?php
    endif;
    ob_start();
    ?>
    <div class="categories-wrapper">
        <div class="info-wrap">
            <h2><?php echo esc_html((ot_get_option('comment_form_title') != '') ? ot_get_option('comment_form_title') : esc_html__('Leave a Reply', 'foreverwedding')); ?></h2>
        </div>
    </div>
    <?php
    $coment_title = ob_get_contents();
    ob_end_clean();


    global $aria_req;
    $args = array(
        'id_form' => 'commentform',
        'id_submit' => 'submit-comment',
        'title_reply' => $coment_title,
        'title_reply_to' => esc_html__('Leave a Reply to %s', 'foreverwedding'),
        'cancel_reply_link' => esc_html__('Cancel Reply', 'foreverwedding'),
        'label_submit' => esc_html__('SUBMIT', 'foreverwedding'),
        'comment_field' => '' .
        '<textarea id="comment" class="form-control" name="comment" placeholder="Message" rows="3" cols="1" aria-required="true"></textarea>',
        'must_log_in' => '<p class="must-log-in">' .
        sprintf(wp_kses('You must be <a href="%s">logged in</a> to post a comment.', 'foreverwedding'), wp_login_url(apply_filters('the_permalink', get_permalink()))) . '</p>',
        'logged_in_as' => '<p class="logged-in-as">' . sprintf(wp_kses('Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'foreverwedding'), admin_url('profile.php'), $user_identity, wp_logout_url(apply_filters('the_permalink', get_permalink()))) . '</p>',
        'comment_notes_before' => '',
        'comment_notes_after' => '',
        'fields' => apply_filters('comment_form_default_fields', array(
            'author' =>
            ' <input id="author" class="form-control" name="author" placeholder="Your Name" type="text"  value="' . (esc_attr($commenter['comment_author'] ? $commenter['comment_author'] : '' )) . '" size="30"' . $aria_req . ' />',
            'email' =>
            '<input id = "email" class="form-control" name = "email" placeholder="Email" type = "text" value = "' . esc_attr($commenter['comment_author_email'] ? $commenter['comment_author_email'] : '' ) . '" size = "30"' . $aria_req . ' />',
                )
        ),
    );
    comment_form($args);
    ?>

</div><!-- #comments .comments-area -->
<?php 
