/**
 *ForeverWedding - Custom JS
 *@since  foreverwedding 1.0.0
 */

jQuery(function($) {
    "use strict";

    /*
     * Single Page Mod
     ****************************************/
    if ('on' == FOREVERWEDDING_SITE_OPTION.site_mod) {

        var $modElementID = '';

        $('.menu-primary-navigation-container > ul > li > a').click(function(e) {
            e.stopPropagation();
            if (FOREVERWEDDING_SITE_OPTION.site_url == location.href.substring(0, location.href.lastIndexOf("/") + 1) && location.href.lastIndexOf("?") == '-1') {
                e.preventDefault();
                var $offset = '';
                var $scrollTime = 500;
                var $href = $(this).attr('href');
                if ($href.length) {
                    e.preventDefault();

                    $offset = $($href).offset().top;

                    if (Math.abs($(window).scrollTop() - $offset) / 100 * 20 > $scrollTime) {
                        $scrollTime = Math.abs($(window).scrollTop() - $offset) / 100 * 20;
                    }

                    $('html, body').stop().animate({
                        scrollTop: $offset
                    }, $scrollTime, function() {
                        window.location.href = $href;
                    });
                }

            }
        });

    }

    /**
     * ForeverWedding - Comment Form
     * @since foreverwedding 1.0.0
     */

    if ($(".people").length) {
        $(".people").owlCarousel({
            autoPlay: 3000,
            items: 4,
            itemsDesktop: [1199, 4],
            itemsDesktopSmall: [979, 4],
            itemsTablet: [768, 3],
            itemsMobile: [767, 1],
            navigation: true

        });
    }

    if ($(".people-thought").length) {
        $(".people-thought").owlCarousel({
            autoPlay: 3000,
            items: 3,
            itemsDesktop: [1199, 3],
            itemsDesktopSmall: [979, 3],
            itemsTablet: [768, 3],
            itemsMobile: [767, 1],
            navigation: true

        });
    }
    if ($(".wedding-item").length) {
        $(".wedding-item").owlCarousel({
            autoPlay: 3000,
            items: 3,
            itemsDesktop: [1199, 3],
            itemsDesktopSmall: [979, 3],
            itemsTablet: [768, 3],
            itemsMobile: [767, 1],
            navigation: true

        });
    }
    if ($(".partner-slider").length) {
        $(".partner-slider").owlCarousel({
            autoPlay: 3000,
            items: 4,
            itemsDesktop: [1199, 4],
            itemsDesktopSmall: [979, 3],
            itemsTablet: [768, 3],
            itemsMobile: [767, 1],
            navigation: true
        });
    }
    if ($(".team-slider").length) {
        $(".team-slider").owlCarousel({
            autoPlay: 3000,
            items: 3,
            itemsDesktop: [1199, 3],
            itemsDesktopSmall: [992, 3],
            itemsTablet: [768, 3],
            itemsMobile: [767, 1],
            navigation: true

        });
    }

    $('.menu-primary-menu-container li').each(function() {
        if ($(this).find('ul').hasClass('sub-menu')) {
            $(this).append("<i class='arrow-mob'>&nbsp;</i>");            
        }
    });
    $(".home-menu").click(function() {
        $(this).toggleClass("active");
        $(this).toggleClass("remove");
        $(".navigation").slideToggle(500);
    });
       $('.navigation li').click(function() {
        if ($(window).width() < 768) {
            $(this).parents('.navbar-collapse').slideToggle(500);       
        }
    });
    
    $('button.navbar-toggle').click(function(){    	
    	$('.navbar-collapse').slideToggle(500);   
    });

    $('.navigation li').click(function() {
        if ($(window).width() < 768) {
            $(this).children('.drop-down').slideToggle();
        }
    });

    if ($('.fancybox-button').length) {
        $(".fancybox-button").fancybox({
            prevEffect: 'none',
            nextEffect: 'none',
            closeBtn: true,
            helpers: {
                title: {
                    type: 'inside'
                },
                buttons: {}
            }
        });
    }

    $('.control').on('click', function() {

        $(this).remove();
        var video = '<iframe src="' + $('.video img').attr('data-video') + '"></iframe>';
        console.log($('.video > img').attr('data-video'));
        $('.video img').after(video);
        return false;
    });
    var projets = FOREVERWEDDING_SITE_OPTION.projets;
    var awards = FOREVERWEDDING_SITE_OPTION.awards;
    var montre = FOREVERWEDDING_SITE_OPTION.montre;
    var hours = FOREVERWEDDING_SITE_OPTION.hours;
    if ($('.status').length) {
        $('.status').appear(function() {
            $('.project-1').countTo({
                from: 0,
                to: projets
            });

            $('.project-2').countTo({
                from: 0,
                to: awards
            });

            $('.project-3').countTo({
                from: 0,
                to: montre
            });

            $('.project-4').countTo({
                from: 0,
                to: hours
            });

        });

    }
    if ($("#commentform").length > 0) {

        $("#commentform").submit(function() {
            var $cmtFlag = true;
            $("#email, #comment ,#author").removeClass('foreverwedding-required');
            if ($('#email').length > 0) {
                var $emailRgx = /^([a-zA-Z.0-9])+@([a-zA_Z0-9])+\.([a-zA-Z])/;
                var $cmauthor = $("#author").val();
                var $cmemail = $("#email").val();
                if ($cmauthor == "") {
                    $("#author").addClass('foreverwedding-required');
                    $cmtFlag = false;
                }
                if ($cmemail == "" || !$emailRgx.test($cmemail)) {
                    $("#email").addClass('foreverwedding-required');
                    $cmtFlag = false;
                }
            }
            var $cmmsg = $("#comment").val();
            if ($cmmsg == "") {
                $("#comment").addClass('foreverwedding-required');
                $cmtFlag = false;
            }
            return $cmtFlag;
        });

    }

    /**
     *ForeverWedding - Search Form
     *@since  foreverwedding 1.0.0
     */

    if ($("form.search-box").length > 0) {
        $("form.search-box").submit(function() {
            var $serchFlag = true;
            $("form.search-box input[name=s]").removeClass('foreverwedding-required');
            var $serchmsg = $("form.search-box input[name=s]").val();
            if ($serchmsg == "") {
                $("form.search-box input[name=s]").addClass('foreverwedding-required');
                $serchFlag = false;
            }
            return $serchFlag;
        });
    }

    $('.menu-item-has-children > i').click(function(e) {
        if ($(window).width() < 768) {
            e.preventDefault();
            $('.navbar-collapse').stop().slideUp();
             $(this).prev('.navbar-collapse').stop().toggle();
            $(this).toggleClass('arrow-move');
           
             $('.sub-menu').slideToggle();
        }
    })


    $(window).resize(function() {
        if ($(window).width() >= 768) {
            $('.sub-menu').attr('style', '');
        }
    });

    var $headerThreeHeight = $('.header-three').height();
    $('.header-three + *').css('margin-top', (0 - $headerThreeHeight));

    if ($('.widget_archive li a').length) {
        $('.widget_archive li a').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }
    if ($('.widget_categories li a').length) {
        $('.widget_categories li a').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }
    if ($('.widget_pages li a').length) {
        $('.widget_pages li a').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }

    if ($('.widget_meta li a').length) {
        $('.widget_meta li a').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }
    if ($('.widget_recent_comments li').length) {
        $('.widget_recent_comments li').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }
    if ($('.widget_recent_entries li a').length) {
        $('.widget_recent_entries li a').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }
    if ($('.widget_nav_menu li a').length) {
        $('.widget_nav_menu li a').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }
    if ($('.widget_rss li a:first-child').length) {
        $('.widget_rss li a:first-child').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }

    if ($('#footer .foot-nav li a').length) {
        $('#footer .foot-nav li a').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }

    if ($('audio.audio').length) {
        $('audio.audio').each(function() {
            $(this).audioPlayer();
        });
    }
    if ($('.woocommerce.widget_product_categories').length) {
        $('.woocommerce.widget_product_categories > ul.product-categories').addClass('blog-list-sidebar add-arrow');
    }
    if ($('.woocommerce.widget_product_tag_cloud').length) {
        $('.woocommerce.widget_product_tag_cloud').addClass('widget_tag_cloud');
    }

    if ($('.blog-list-sidebar.add-arrow li a').length) {
        $('.blog-list-sidebar.add-arrow li a').each(function() {
            $(this).prepend('<i class="fa fa-caret-right"> </i>');
        });
    }

    if ($('#owl-slider').length) {

        $("#owl-slider").owlCarousel({
            autoPlay: 3000, //Set AutoPlay to 3 seconds

            items: 3,
            itemsDesktop: [1199, 3],
            itemsDesktopSmall: [979, 2],
            itemsMobile: [600, 1]

        });
    }
    if ($('#owl-slider-clients').length) {

        $("#owl-slider-clients").owlCarousel({
            autoPlay: 3000, //Set AutoPlay to 3 seconds

            items: 6,
            itemsDesktop: [1199, 6],
            itemsDesktopSmall: [979, 6],
            itemsTablet: [768, 3]

        });
    }

    if ($('#owl-slider1').length) {

        $("#owl-slider1").owlCarousel({
            autoPlay: 3000, //Set AutoPlay to 3 seconds

            items: 3,
            itemsDesktop: [1199, 3],
            itemsDesktopSmall: [979, 3]

        });
    }

    if ($('#owl-slider2').length) {

        $("#owl-slider2").owlCarousel({
            autoPlay: 3000, //Set AutoPlay to 3 seconds

            items: 6,
            itemsDesktop: [1199, 6],
            itemsDesktopSmall: [979, 6],
            itemsTablet: [768, 3]

        });
    }

    $('.nav ,.blog-paging-list,.blog-sidebar-paging-list').find('li').on('click', function() {
        $(this).siblings('li').removeClass('active');
        $(this).addClass('active');
    });

    if ($(window).width() < 768) {
        $('.navbar-nav li').on('click', function() {
            $('.dropdown').slideUp();
            $(this).children('.dropdown').slideDown();

        });
    }
    ;

    // Svg implement
    jQuery('img.svg').each(function() {
        var $img = jQuery(this);
        var imgID = $img.attr('id');
        var imgClass = $img.attr('class');
        var imgURL = $img.attr('src');

        jQuery.get(imgURL, function(data) {
            // Get the SVG tag, ignore the rest
            var $svg = jQuery(data).find('svg');

            // Add replaced image's ID to the new SVG
            if (typeof imgID !== 'undefined') {
                $svg = $svg.attr('id', imgID);
            }
            // Add replaced image's classes to the new SVG
            if (typeof imgClass !== 'undefined') {
                $svg = $svg.attr('class', imgClass + ' replaced-svg');
            }

            // Remove any invalid XML tags as per http://validator.w3.org
            $svg = $svg.removeAttr('xmlns:a');

            // Replace image with new SVG
            $img.replaceWith($svg);

        }, 'xml');

    });

    //==============Map Function

    //================================
    if (jQuery('#map-view').length) {
        var pos = new google.maps.LatLng(FOREVERWEDDING_HOTELS[0][0], FOREVERWEDDING_HOTELS[0][1]);

        var map = new google.maps.Map(document.getElementById('map-view'), {
            zoom: 16,
            center: pos,
            scrollwheel: false,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        });
        var pos = [];
        jQuery.each(FOREVERWEDDING_HOTELS, function($index, $value) {
            new google.maps.Marker({
                position: new google.maps.LatLng($value[0], $value[1]),
                map: map,
                draggable: false,
                icon: FOREVERWEDDING_SITE_OPTION.icourl
            });
        });
    }

    if (jQuery('#map').length) {
        var initialize = function() {
            //function initialize() {
            var pos = new google.maps.LatLng(FOREVERWEDDING_SITE_OPTION.lat, FOREVERWEDDING_SITE_OPTION.lng);
            var mapProp = {
                center: pos,
                zoom: 16,
                scrollwheel: false,
                mapTypeId: google.maps.MapTypeId.ROADMAP
            };
            var marker = new google.maps.Marker({
                position: pos,
                map: map,
                icon: FOREVERWEDDING_SITE_OPTION.icourl,
                draggable: false
            });

            var map = new google.maps.Map(document.getElementById("map"), mapProp);
            marker.setMap(map);

        };

        google.maps.event.addDomListener(window, 'load', initialize);

    }



    $(window).load(function() {
        $('.loader').delay(50).fadeOut();
         if ($(window).width() < 768) {
     	$('#header.intelligent').attr('style', 'position: absolute !important');
     }
    });

    if ($('.count-down').length) {
    	var month = FOREVERWEDDING_SITE_OPTION.count_month;
        var date = FOREVERWEDDING_SITE_OPTION.count_date;
        var year = FOREVERWEDDING_SITE_OPTION.count_year;
        var austDay = new Date();
        austDay = new Date(year, month - 1, date);
        jQuery('.defaultCountdown').countdown({
            until: austDay
        });
    }
    if ($('.comming-soon-countdown').length) {
        var month = FOREVERWEDDING_SITE_OPTION.month;
        var date = FOREVERWEDDING_SITE_OPTION.date;
        var year = FOREVERWEDDING_SITE_OPTION.year;

        var commin_soon = new Date();
        commin_soon = new Date(year, month - 1, date);
        jQuery('.comming-soon-countdown').countdown({
            until: commin_soon
        });
    }

    /*	if($('.count-down').length){
     var austDay = new Date();
     austDay = new Date(2017, 7 - 1, 22);
     jQuery('.defaultCountdown').countdown({
     until : austDay
     });
     }
     */

    // Countdown
    // To change date, simply edit: var endDate = "January 17, 2017 20:39:00";
    /*            jQuery(function () {
     var abc = FOREVERWEDDING_SITE_OPTION.month;
     var str1 = FOREVERWEDDING_SITE_OPTION.date;
     var str2 = FOREVERWEDDING_SITE_OPTION.year;
     var res = abc + ' ' + str1 + ', '+ str2 + ' 00:00:00';
     var endDate = res;
     jQuery('.app-countdown .row').countdown({
     date: endDate,
     render: function (data) {
     jQuery(this.el).html('<div><div><span class="text-primary">' + (parseInt(this.leadingZeros(data.years, 2) * 365) + parseInt(this.leadingZeros(data.days, 2))) + '</span><span><b>Days</b></span></div><div><span class="text-primary">' + this.leadingZeros(data.hours, 2) + '</span><span><b>Hours</b></span></div></div><div class=""><div><span class="text-primary">' + this.leadingZeros(data.min, 2) + '</span><span><b>Minutes</b></span></div><div><span class="text-primary">' + this.leadingZeros(data.sec, 2) + '</span><span><b>Seconds</b></span></div></div>');
     }
     });
     }); 
     */
    // Text rotate
    jQuery(".home-text .rotate").textrotator({
        animation: "fade",
        speed: 3000
    });

    $('#menu-primary-menu li > a').bind('click', function(e) {

        var target = $(this).attr("href");
        if ((target.charAt(0)) == "#") {
            e.preventDefault();
            var $target = $(target);
            if ($target.offset() != undefined) {
                var goto = parseInt($target.offset().top) - parseInt(0)
                $('html, body').stop().animate({
                    'scrollTop': goto
                }, 500, 'swing', function() {
                });
            } else {

            }

        } else {

        }

    });

});

