<?php

/**
 * Forever Wedding - Plan Wedding Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_wedding_plan');

function foreverwedding_wedding_plan() {
    vc_map(array(
        "name" => esc_html__("Forever Wedding Wedding Plan section", 'foreverwedding'),
        "base" => "foreverwedding_wedding_plan",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Wedding Plan Title", 'foreverwedding'),
                "param_name" => "wedding_plan",
                "value" => '',
                "description" => esc_html__("Enter special wishes here", 'foreverwedding')
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section button link", 'foreverwedding'),
                "param_name" => "btn_link",
                "value" => '',
                "description" => esc_html__("Enter button link", 'foreverwedding')
            ),
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section button label", 'foreverwedding'),
                "param_name" => "btn_text",
                "value" => '',
                "description" => esc_html__("Enter button label", 'foreverwedding')
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_wedding_plan extends WPBakeryShortCode { }
