<?php

/**
 * Forever Wedding - wedding info 
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action( 'vc_before_init', 'foreverwedding_wedding_info' );

function foreverwedding_wedding_info(){
 vc_map(array(
        "name" => esc_html__("Foreverwedding wedding info section", 'foreverwedding'),
        "base" => "foreverwedding_wedding_info",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Title", 'foreverwedding'),
                "param_name" => "title",
                "value" => '',
                "description" => esc_html__("Enter section title", 'foreverwedding')
            ),
            array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Wedding Info Section Repeater", "foreverwedding"),
                "param_name" => "wedding_info_section_repeater",
                "description" => esc_html__("Wedding Info Section Repeater", "foreverwedding"),
                'params' => array(
                array(
                        'type' => 'attach_image',
                        'value' => '',
                        'heading' => 'Upload Wedding Image',
                        'param_name' => 'wedding_img',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Wedding title',
                        'param_name' => 'wedding_title',
                    ),
                   array(
                        "type" => "textarea",
                        "holder" => "",
                        "class" => "",
                        "heading" => esc_html__("Wedding Content", 'foreverwedding'),
                        "param_name" => "wedding_content",
                        "value" => '',
                        "description" => esc_html__("Enter wedding content here.", 'foreverwedding')
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Wedding Sub title',
                        'param_name' => 'wedding_sub_title',
                    ),
                   array(
                        "type" => "textarea",
                        "holder" => "",
                        "class" => "",
                        "heading" => esc_html__("Wedding Sub Content", 'foreverwedding'),
                        "param_name" => "wedding_sub_content",
                        "value" => '',
                        "description" => esc_html__("Enter wedding sub content here.", 'foreverwedding')
                    ),
                   array(
            			"type" => "textarea",
            			"holder" => "",
            			"class" => "",
            			"heading" => esc_html__("Wedding Features", 'foreverwedding'),
            			"param_name" => "wedding_features",
            			"value" => '',
            			"description" => esc_html__("Enter wedding features here.", 'foreverwedding')
         			)
                ),
            ),
    )
));
}
class WPBakeryShortCode_foreverwedding_wedding_info extends WPBakeryShortCode { } 
