<?php

/**
 * Forever Wedding - Testimonial Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_testimonial');

function foreverwedding_testimonial() {
    vc_map(array(
        "name" => esc_html__("Forever Wedding Testimonial", 'foreverwedding'),
        "base" => "foreverwedding_testimonial",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Section Title", 'foreverwedding'),
                "param_name" => "title",
                "value" => '',
                "description" => esc_html__("Enter section title", 'foreverwedding')
            ),
                array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "friends_wishes_section_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                 array(
                        "type" => "textarea",
                        "holder" => "",
                        "class" => "",
                        "heading" => esc_html__("Friends Wishes Content", 'foreverwedding'),
                        "param_name" => "wishes_content",
                        "value" => '',
                        "description" => esc_html__("Enter friend wishes content here", 'foreverwedding')
                    ),
                array(
                        'type' => 'attach_image',
                        'value' => '',
                        'heading' => 'Upload Friend Image',
                        'param_name' => 'friend_image',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Friend Name',
                        'param_name' => 'friend_name',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Friend Relation',
                        'param_name' => 'friend_relation',
                    ),
                ),
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_testimonial extends WPBakeryShortCode { }
