<?php

/**
 * Forever Wedding - Status Section
 * 
 * This template is use by js composer plugin 
 * 
 * @package foreverwedding
 * @subpackage foreverwedding.vc_templates.vc-map
 * @since foreverwedding 1.0.0
 */
add_action('vc_before_init', 'foreverwedding_status_section');

function foreverwedding_status_section() {
    vc_map(array(
        "name" => esc_html__("Foreverwedding status section", 'foreverwedding'),
        "base" => "foreverwedding_status_section",
        "class" => "",
        "icon" => get_template_directory_uri() . "/assets/admin/vc-icon.png",
        "category" => esc_html__('Forever Wedding', "foreverwedding"),
        "params" => array(
            array(
                "type" => "param_group",
                "class" => "",
                "heading" => esc_html__("Section Repeater", "foreverwedding"),
                "param_name" => "status_section_repeater",
                "description" => esc_html__("Section Repeater", "foreverwedding"),
                'params' => array(
                    array(
                        'type' => 'iconpicker',
                        'value' => '',
                        'heading' => 'Select Icon',
                        'param_name' => 'img_class_name',
                        "description" => esc_html__("Select Icon here", 'foreverwedding')
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter Status Heading',
                        'param_name' => 'counter_status',
                    ),
                    array(
                        'type' => 'textfield',
                        'value' => '',
                        'heading' => 'Enter type of status',
                        'param_name' => 'status_type',
                    ),
                ),
            ),
        )
    ));
}

class WPBakeryShortCode_foreverwedding_status_section extends WPBakeryShortCode { }
